/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.rest.impl;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openthinclient.api.importer.model.ProfileReference;
import org.openthinclient.api.importer.model.ProfileType;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.api.rest.model.Client;
import org.openthinclient.api.rest.model.Configuration;
import org.openthinclient.api.rest.model.Device;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.HardwareType;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.Realm;
import org.openthinclient.common.model.schema.EntryNode;
import org.openthinclient.common.model.schema.Node;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaLoadingException;

public class ModelMapper {
    public org.openthinclient.api.rest.model.Application translate(Realm realm, Application source) {
        org.openthinclient.api.rest.model.Application application = new org.openthinclient.api.rest.model.Application();
        this.translate(realm, (Profile)source, application);
        source.getMembers().forEach(directoryObject -> application.addMember(directoryObject.getDn()));
        return application;
    }

    public Client translate(Realm realm, org.openthinclient.common.model.Client source) {
        Client client = new Client();
        this.translate(realm, (Profile)source, client);
        client.setMacAddress(source.getMacAddress());
        if (source.getLocation() != null) {
            client.setLocation(this.translate(realm, source.getLocation()));
        }
        if (source.getHardwareType() != null) {
            client.setHardwareType(this.translate(realm, source.getHardwareType()));
        }
        return client;
    }

    public Configuration createConfiguration(Realm realm, Profile source) {
        Schema schema = this.getSchema(realm, source);
        if (schema == null) {
            return null;
        }
        Configuration configuration = new Configuration();
        this.applyConfiguration(source, configuration, schema.getChildren(), "");
        return configuration;
    }

    public Device translate(Realm realm, org.openthinclient.common.model.Device source) {
        Device device = new Device();
        this.translate(realm, (Profile)source, device);
        source.getMembers().forEach(member -> device.addMember(member.toString()));
        return device;
    }

    public org.openthinclient.api.rest.model.Printer translate(Realm realm, Printer source) {
        org.openthinclient.api.rest.model.Printer printer = new org.openthinclient.api.rest.model.Printer();
        this.translate(realm, (Profile)source, printer);
        return printer;
    }

    public void translate(Realm realm, Profile source, AbstractProfileObject target) {
        Schema schema = this.getSchema(realm, source);
        target.setSubtype(schema.getName());
        target.setName(source.getName());
        target.setDescription(source.getDescription());
        target.setConfiguration(this.createConfiguration(realm, source));
    }

    public org.openthinclient.api.rest.model.Location translate(Realm realm, Location source) {
        org.openthinclient.api.rest.model.Location location = new org.openthinclient.api.rest.model.Location();
        this.translate(realm, (Profile)source, location);
        return location;
    }

    public org.openthinclient.api.rest.model.HardwareType translate(Realm realm, HardwareType source) {
        org.openthinclient.api.rest.model.HardwareType target = new org.openthinclient.api.rest.model.HardwareType();
        this.translate(realm, (Profile)source, target);
        if (source.getDevices() != null) {
            Set<ProfileReference> deviceSet = source.getDevices().stream().map(device -> new ProfileReference(ProfileType.DEVICE, device.getName())).collect(Collectors.toSet());
            target.setDevices(deviceSet);
        }
        return target;
    }

    private Schema getSchema(Realm realm, Profile source) {
        if (realm != null) {
            try {
                source.initSchemas(realm);
            }
            catch (SchemaLoadingException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return source.getSchema(realm);
        }
        catch (SchemaLoadingException e) {
            throw new RuntimeException(e);
        }
    }

    private void applyConfiguration(Profile profile, Configuration configuration, List<Node> configurationNodes, String prefix) {
        for (Node n : configurationNodes) {
            if (n instanceof EntryNode) {
                String key = prefix + n.getName();
                String val = profile.getValue(key);
                configuration.setAdditionalProperty(key, val);
            }
            if (n.getChildren() == null || n.getChildren().size() <= 0) continue;
            this.applyConfiguration(profile, configuration, n.getChildren(), prefix + n.getName() + ".");
        }
    }
}

