/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.ldap.LdapName;
import org.openthinclient.api.importer.model.ProfileType;
import org.openthinclient.api.rest.model.AbstractProfileObject;
import org.openthinclient.api.rest.model.Application;
import org.openthinclient.api.rest.model.Client;
import org.openthinclient.api.rest.model.Device;
import org.openthinclient.api.rest.model.HardwareType;
import org.openthinclient.api.rest.model.Location;
import org.openthinclient.api.rest.model.Printer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ldif.MappingLdifReader;
import org.springframework.batch.item.ldif.RecordMapper;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.data.util.Pair;
import org.springframework.ldap.core.LdapAttributes;

public class Ldif2JsonModelParser {
    Logger logger = LoggerFactory.getLogger(Ldif2JsonModelParser.class);
    private File file;
    private Pair<String, String> replacement;
    private String envDN;

    public Ldif2JsonModelParser(File ldifFile, String envDN, Pair<String, String> replacement) {
        this.file = ldifFile;
        this.envDN = envDN;
        this.replacement = replacement;
    }

    public List<AbstractProfileObject> parse() throws Exception {
        String line;
        MappingLdifReader reader = new MappingLdifReader();
        reader.setRecordMapper((RecordMapper)new RecordMapper<AbstractProfileObject>(){

            public AbstractProfileObject mapRecord(LdapAttributes attributes) {
                AbstractProfileObject profileObject;
                ProfileType profileType;
                if (attributes == null) {
                    return null;
                }
                LdapName name = attributes.getName();
                Attribute objectClass = attributes.get("objectClass");
                Attribute description = attributes.get("description");
                Attribute uniquemember = attributes.get("uniquemember");
                Attribute cn = attributes.get("cn");
                Attribute nismapname = attributes.get("nismapname");
                Attribute nismapentry = attributes.get("nismapentry");
                String ou = Ldif2JsonModelParser.this.getString(name, "ou");
                if (ou.equals("hwtypes")) {
                    profileType = ProfileType.HARDWARETYPE;
                } else if (ou.equals("apps")) {
                    profileType = ProfileType.APPLICATION;
                } else if (ou.equals("printers")) {
                    profileType = ProfileType.PRINTER;
                } else if (ou.equals("clients")) {
                    profileType = ProfileType.CLIENT;
                } else if (ou.equals("locations")) {
                    profileType = ProfileType.LOCATION;
                } else if (ou.equals("devices")) {
                    profileType = ProfileType.DEVICE;
                } else {
                    Ldif2JsonModelParser.this.logger.debug("Skipping entry because there is no JsonModel-object for type '" + ou + "'.");
                    return new AbstractProfileObject(null){};
                }
                switch (profileType) {
                    case CLIENT: {
                        profileObject = new Client();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "cn"));
                        break;
                    }
                    case HARDWARETYPE: {
                        profileObject = new HardwareType();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "cn"));
                        break;
                    }
                    case APPLICATION: {
                        profileObject = new Application();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "cn"));
                        break;
                    }
                    case DEVICE: {
                        profileObject = new Device();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "cn"));
                        break;
                    }
                    case PRINTER: {
                        profileObject = new Printer();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "cn"));
                        break;
                    }
                    case LOCATION: {
                        profileObject = new Location();
                        profileObject.setName(Ldif2JsonModelParser.this.getString(name, "l"));
                        break;
                    }
                    default: {
                        return new AbstractProfileObject(null){};
                    }
                }
                if (description != null) {
                    try {
                        profileObject.setDescription(description.get().toString());
                    }
                    catch (NamingException e) {
                        Ldif2JsonModelParser.this.logger.warn("Cannot get description", (Throwable)e);
                    }
                }
                try {
                    String configKey = null;
                    if (cn != null && cn.get() != null) {
                        configKey = cn.get().toString();
                    }
                    if (configKey != null && nismapentry != null && nismapentry.get() != null) {
                        profileObject.getConfiguration().setAdditionalProperty(configKey, nismapentry.get().toString());
                    }
                }
                catch (NamingException e) {
                    Ldif2JsonModelParser.this.logger.debug("Cannot handle cn or nismapentry", (Throwable)e);
                }
                try {
                    if (uniquemember != null && uniquemember.get() != null) {
                        if (profileType == ProfileType.DEVICE) {
                            ((Device)profileObject).addMember(uniquemember.get().toString());
                        }
                        if (profileType == ProfileType.APPLICATION) {
                            ((Application)profileObject).addMember(uniquemember.get().toString());
                        }
                    }
                }
                catch (NamingException e) {
                    Ldif2JsonModelParser.this.logger.debug("Cannot handle uniquemember", (Throwable)e);
                }
                return profileObject;
            }
        });
        FileInputStream inputStream = new FileInputStream(this.file);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder out = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            if (this.replacement == null) {
                out.append(line).append("\n");
                continue;
            }
            out.append(line.replaceAll((String)this.replacement.getFirst(), (String)this.replacement.getSecond())).append("\n");
        }
        reader.setResource((Resource)new ByteArrayResource(out.toString().getBytes()));
        reader.open(new ExecutionContext());
        ArrayList<AbstractProfileObject> parseResults = new ArrayList<AbstractProfileObject>();
        AbstractProfileObject profileObject = (AbstractProfileObject)reader.read();
        while (profileObject != null) {
            if (profileObject.getType() != null) {
                parseResults.add(profileObject);
                if (this.logger.isDebugEnabled()) {
                    ObjectMapper om = new ObjectMapper();
                    this.logger.debug(om.writeValueAsString((Object)profileObject));
                }
            }
            profileObject = (AbstractProfileObject)reader.read();
        }
        HashMap result = new HashMap();
        parseResults.forEach(apo -> {
            if (result.containsKey(apo.getName())) {
                AbstractProfileObject object = (AbstractProfileObject)result.get(apo.getName());
                object.getConfiguration().setAdditionalProperties(apo.getConfiguration().getAdditionalProperties());
                if (object instanceof Device && apo instanceof Device) {
                    ((Device)object).addMembers(((Device)apo).getMembers());
                }
                if (object instanceof Application && apo instanceof Application) {
                    ((Application)object).addMembers(((Application)apo).getMembers());
                }
            } else {
                result.put(apo.getName(), apo);
            }
        });
        return result.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    private String getString(LdapName name, String part) {
        if (name == null || name.toString().indexOf(part) == -1) {
            return "";
        }
        int startIdx = name.toString().lastIndexOf(part + "=", name.toString().indexOf(this.envDN) - 1) + part.length() + 1;
        return name.toString().substring(startIdx, name.toString().indexOf(",", startIdx));
    }
}

