/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.api.ws;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.handler.TextWebSocketHandler;

@Component
public class WebSocketHandler
extends TextWebSocketHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebSocketHandler.class);
    private static Set<WebSocketSession> sessions = new HashSet<WebSocketSession>();
    private static Map<String, List<BiConsumer<WebSocketSession, String>>> consumers = new ConcurrentHashMap<String, List<BiConsumer<WebSocketSession, String>>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        Set<WebSocketSession> set = sessions;
        synchronized (set) {
            sessions.add(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterConnectionClosed(WebSocketSession session, CloseStatus status) throws Exception {
        super.afterConnectionClosed(session, status);
        Set<WebSocketSession> set = sessions;
        synchronized (set) {
            sessions.remove(session);
        }
    }

    public void register(String message_type, BiConsumer<WebSocketSession, String> consumer) {
        if (!consumers.containsKey(message_type)) {
            consumers.put(message_type, new CopyOnWriteArrayList());
        }
        consumers.get(message_type).add(consumer);
    }

    public void handleTextMessage(WebSocketSession session, TextMessage message) throws InterruptedException, IOException {
        String payload = (String)message.getPayload();
        String[] parts = payload.split("\\R", 2);
        String message_type = parts[0];
        if (consumers.containsKey(message_type)) {
            for (BiConsumer<WebSocketSession, String> consumer : consumers.get(message_type)) {
                try {
                    consumer.accept(session, payload);
                }
                catch (Exception ex) {
                    LOG.error("Error in websocket handler", (Throwable)ex);
                }
            }
        } else {
            String remote_ip = session.getRemoteAddress().getAddress().getHostAddress();
            LOG.error("Received message with unknown type '{}' from IP {}", (Object)message_type, (Object)remote_ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendToAll(String message_type) {
        Set<WebSocketSession> set = sessions;
        synchronized (set) {
            for (WebSocketSession session : sessions) {
                try {
                    session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)message_type));
                }
                catch (IOException ex) {
                    LOG.error("Failed to send {} to {}", (Object)message_type, (Object)session.getRemoteAddress());
                }
            }
        }
    }
}

