/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web;

import com.vaadin.server.CustomizedSystemMessages;
import com.vaadin.server.SystemMessages;
import com.vaadin.server.SystemMessagesInfo;
import com.vaadin.server.SystemMessagesProvider;
import com.vaadin.spring.annotation.UIScope;
import java.util.Locale;
import org.openthinclient.api.logs.LogMvcConfiguration;
import org.openthinclient.api.rest.ApplianceRestApiConfiguration;
import org.openthinclient.api.rest.RestApiConfiguration;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.SchemaService;
import org.openthinclient.web.VaadinCustomizationConfiguration;
import org.openthinclient.web.WebApplicationSecurityConfiguration;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.sidebar.OTCSideBarUtils;
import org.openthinclient.web.support.config.SystemReportingConfiguration;
import org.openthinclient.web.ui.ManagerSideBarSections;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.security.SecurityAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.i18n.SessionLocaleResolver;
import org.vaadin.spring.i18n.I18N;
import org.vaadin.spring.i18n.MessageProvider;
import org.vaadin.spring.i18n.ResourceBundleMessageProvider;
import org.vaadin.spring.sidebar.annotation.EnableSideBar;

@SpringBootApplication(exclude={SecurityAutoConfiguration.class})
@EnableSideBar
@Import(value={WebApplicationSecurityConfiguration.class, VaadinCustomizationConfiguration.class, RestApiConfiguration.class, ApplianceRestApiConfiguration.class, LogMvcConfiguration.class, SystemReportingConfiguration.class})
public class WebApplicationConfiguration {
    @Bean
    SystemMessagesProvider systemMessagesProvider() {
        return new SystemMessagesProvider(){
            private static final long serialVersionUID = 2570216527087874367L;

            public SystemMessages getSystemMessages(SystemMessagesInfo systemMessagesInfo) {
                CustomizedSystemMessages systemMessages = new CustomizedSystemMessages();
                systemMessages.setSessionExpiredNotificationEnabled(false);
                return systemMessages;
            }
        };
    }

    @Bean
    MessageProvider communicationMessages() {
        return new ResourceBundleMessageProvider("i18n/console-web-messages");
    }

    @Bean(name={"settingsSideBar"})
    @UIScope
    OTCSideBar settingsSideBar(OTCSideBarUtils utils) {
        return new OTCSideBar("server-management", utils);
    }

    @Bean(name={"deviceSideBar"})
    @UIScope
    OTCSideBar deviceSideBar(OTCSideBarUtils utils) {
        return new OTCSideBar("client-management", utils);
    }

    @Bean
    @UIScope
    OTCSideBarUtils sideBarUtils(ApplicationContext applicationContext, I18N i18n) {
        return new OTCSideBarUtils(applicationContext, i18n);
    }

    @Bean
    public LocaleResolver localeResolver() {
        SessionLocaleResolver slr = new SessionLocaleResolver();
        slr.setDefaultLocale(Locale.GERMAN);
        return slr;
    }

    @Bean
    public ManagerSideBarSections dashboardSections() {
        return new ManagerSideBarSections();
    }

    @Bean
    public SchemaService schemaService(PackageManager packageManager, ApplicationService applicationService, SchemaProvider schemaProvider, RealmService realmService) {
        return new SchemaService(packageManager, applicationService, schemaProvider, realmService);
    }

    @Bean
    public DashboardNotificationService dashboardNotificationService() {
        return new DashboardNotificationService.Dummy();
    }
}

