/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.component;

import com.vaadin.server.FontAwesome;
import com.vaadin.server.Sizeable;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.vaadin.viritin.button.MButton;
import org.vaadin.viritin.layouts.MHorizontalLayout;

public class NotificationDialog {
    private final Window window;
    private final HorizontalLayout footer;
    private final Button closeButton;
    private final VerticalLayout content;

    public NotificationDialog(String caption, String description, NotificationDialogType type) {
        this.window = new Window(caption);
        this.window.setResizable(false);
        this.window.setClosable(false);
        this.window.setWidth(60.0f, Sizeable.Unit.PERCENTAGE);
        this.window.setHeight(null);
        this.window.center();
        this.content = new VerticalLayout();
        this.content.setMargin(true);
        this.content.setSpacing(true);
        this.content.setWidth("100%");
        Label check = null;
        switch (type) {
            case SUCCESS: {
                check = new Label(FontAwesome.CHECK_CIRCLE.getHtml() + " Success", ContentMode.HTML);
                check.setStyleName("state-label-success-xl");
                break;
            }
            case ERROR: {
                check = new Label(FontAwesome.TIMES_CIRCLE.getHtml() + " Failed", ContentMode.HTML);
                check.setStyleName("state-label-error-xl");
                break;
            }
        }
        if (check != null) {
            this.content.addComponent(check);
        }
        Label infoText = new Label(description, ContentMode.HTML);
        infoText.setStyleName("v-label-notification-dialog-description");
        this.content.addComponent((Component)infoText);
        this.footer = (HorizontalLayout)((MHorizontalLayout)new MHorizontalLayout().withFullWidth()).withStyleName(new String[]{"v-window-bottom-toolbar"});
        this.closeButton = ((MButton)new MButton("Close").withStyleName(new String[]{"primary"})).withListener((Button.ClickListener & Serializable)event -> this.close());
        this.footer.addComponent((Component)this.closeButton);
        this.footer.setComponentAlignment((Component)this.closeButton, Alignment.MIDDLE_RIGHT);
        this.content.addComponent((Component)this.footer);
        this.window.setContent((Component)this.content);
    }

    public void addContent(Component component) {
        this.content.addComponent(component, this.content.getComponentIndex((Component)this.footer));
    }

    public void open(boolean modal) {
        this.window.setModal(modal);
        UI ui = UI.getCurrent();
        if (!ui.getWindows().contains(this.window)) {
            ui.setPollInterval((int)TimeUnit.SECONDS.toMillis(1L));
            ui.addWindow(this.window);
        }
    }

    public void close() {
        UI.getCurrent().setPollInterval(-1);
        UI.getCurrent().removeWindow(this.window);
    }

    public void addCloseListener(Button.ClickListener listener) {
        this.closeButton.addClickListener(listener);
    }

    public static enum NotificationDialogType {
        SUCCESS,
        ERROR,
        PLAIN;

    }
}

