/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui;

import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.server.Sizeable;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.Label;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.AbstractSummaryDialog;
import org.vaadin.viritin.layouts.MVerticalLayout;

public class AffectedApplicationsSummaryDialog
extends AbstractSummaryDialog {
    private final Collection<Application> affectedApplications;
    private final List<Runnable> proceedCallbacks;

    public AffectedApplicationsSummaryDialog(Collection<Application> affectedApplications) {
        this.affectedApplications = affectedApplications;
        this.proceedCallbacks = new ArrayList<Runnable>();
    }

    @Override
    protected void onCancel() {
        this.close();
    }

    @Override
    protected void createContent(MVerticalLayout content) {
        Label l = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_AFFECTED_APPLICATIONS_HEADLINE, new Object[0]));
        l.addStyleName("huge");
        l.addStyleName("colored");
        content.addComponent((Component)l);
        Label label = new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_AFFECTED_APPLICATIONS_MESSAGE, new Object[0]));
        label.addStyleName("large");
        content.add(new Component[]{label});
        Grid table = new Grid();
        table.setDataProvider((DataProvider)DataProvider.ofCollection(this.affectedApplications));
        table.setSelectionMode(Grid.SelectionMode.NONE);
        table.addColumn(DirectoryObject::getName).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_AFFECTED_APPLICATIONS_TABLE_NAME, new Object[0]));
        table.addColumn((ValueProvider & Serializable)application -> application.getSchema(application.getRealm()).getName()).setCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_AFFECTED_APPLICATIONS_TABLE_SCHEMANAME, new Object[0]));
        table.setWidth(100.0f, Sizeable.Unit.PERCENTAGE);
        table.setHeight(100.0f, Sizeable.Unit.PIXELS);
        content.add(new Component[]{table});
    }

    @Override
    public void update() {
    }

    @Override
    protected void onProceed() {
        this.proceedCallbacks.forEach(Runnable::run);
    }

    public void onProceed(Runnable callback) {
        this.proceedCallbacks.add(callback);
    }
}

