/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.ui.UI;
import java.util.Collection;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsListPresenter;

public class PackageActionOverviewPresenter {
    private final View view;
    private final MessageConveyor mc;
    private PackageDetailsListPresenter.Mode mode;
    private Runnable callback;

    public PackageActionOverviewPresenter(View view) {
        this.view = view;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        view.setPackageNameColumnCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_NAME, new Object[0]));
        view.setPackageVersionColumnCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_PACKAGE_VERSION, new Object[0]));
        view.onPerfomAction(() -> {
            if (this.callback != null) {
                this.callback.run();
            }
        });
    }

    public void setPackages(Collection<Package> otcPackages) {
        this.view.setPackages(otcPackages);
    }

    public PackageDetailsListPresenter.Mode getMode() {
        return this.mode;
    }

    public void setMode(PackageDetailsListPresenter.Mode mode) {
        switch (mode) {
            case UPDATE: 
            case INSTALL: {
                this.view.setViewCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_INSTALL_LABEL_MULTI, new Object[0]));
                this.view.setViewDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_ACTION_INSTALL_DESCRIPTION, new Object[0]));
                this.view.setActionCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_INSTALL_CAPTION, new Object[0]));
                this.view.setActionIcon(VaadinIcons.DOWNLOAD);
                break;
            }
            case UNINSTALL: {
                this.view.setViewCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_UNINSTALL_LABEL_MULTI, new Object[0]));
                this.view.setViewDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_ACTION_UNINSTALL_DESCRIPTION, new Object[0]));
                this.view.setActionCaption(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_UNINSTALL_CAPTION, new Object[0]));
                this.view.setActionIcon(VaadinIcons.TRASH);
            }
        }
        this.mode = mode;
    }

    public void onPerformAction(Runnable callback) {
        this.callback = callback;
    }

    public void show() {
        this.view.show();
    }

    public void hide() {
        this.view.hide();
    }

    public static interface View {
        public void hide();

        public void show();

        public void setPackages(Collection<Package> var1);

        public void setActionCaption(String var1);

        public void setActionIcon(VaadinIcons var1);

        public void setPackageNameColumnCaption(String var1);

        public void setPackageVersionColumnCaption(String var1);

        public void setViewCaption(String var1);

        public void setViewDescription(String var1);

        public void onPerfomAction(Runnable var1);
    }
}

