/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.view;

import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Grid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.Collectors;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.web.pkgmngr.ui.design.PackageActionOverviewDesign;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageActionOverviewPresenter;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.pkgmngr.ui.view.ResolvedPackageItem;

public class PackageActionOverviewView
extends PackageActionOverviewDesign
implements PackageActionOverviewPresenter.View {
    private final Grid.Column<ResolvedPackageItem, String> packageNameColumn;
    private final Grid.Column<ResolvedPackageItem, String> packageVersionColumn;
    private final ListDataProvider<ResolvedPackageItem> dataProvider;
    private Collection<Package> packages;
    private Runnable callback;

    public PackageActionOverviewView() {
        this.packageNameColumn = this.packageSelectionGrid.addColumn(AbstractPackageItem::getName);
        this.packageVersionColumn = this.packageSelectionGrid.addColumn(AbstractPackageItem::getDisplayVersion);
        this.dataProvider = new ListDataProvider(new ArrayList());
        this.packageSelectionGrid.setDataProvider(this.dataProvider);
        this.performActionButton.addClickListener((Button.ClickListener & Serializable)e -> this.callback.run());
    }

    @Override
    public void hide() {
        this.setVisible(false);
    }

    @Override
    public void show() {
        this.setVisible(true);
    }

    @Override
    public void setPackages(Collection<Package> packages) {
        this.packages = packages;
        this.dataProvider.getItems().clear();
        if (packages != null) {
            this.dataProvider.getItems().addAll(packages.stream().map(ResolvedPackageItem::new).collect(Collectors.toList()));
        }
        this.dataProvider.refreshAll();
    }

    @Override
    public void setActionCaption(String caption) {
        this.performActionButton.setCaption(caption);
    }

    @Override
    public void setActionIcon(VaadinIcons icon) {
        this.performActionButton.setIcon((Resource)icon);
    }

    @Override
    public void setPackageNameColumnCaption(String caption) {
        this.packageNameColumn.setCaption(caption);
    }

    @Override
    public void setPackageVersionColumnCaption(String caption) {
        this.packageVersionColumn.setCaption(caption);
    }

    @Override
    public void setViewCaption(String caption) {
        this.labelCaption.setValue(caption);
    }

    @Override
    public void setViewDescription(String description) {
        this.descriptionLabel.setValue(description);
    }

    @Override
    public void onPerfomAction(Runnable callback) {
        this.callback = callback;
    }
}

