/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.navigator.View;
import com.vaadin.shared.ui.ContentMode;
import com.vaadin.shared.ui.window.WindowMode;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.Panel;
import com.vaadin.ui.TextArea;
import com.vaadin.ui.UI;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Base64;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.license.EncryptedLicense;
import org.openthinclient.service.common.license.License;
import org.openthinclient.service.common.license.LicenseError;
import org.openthinclient.service.common.license.LicenseManager;
import org.openthinclient.service.common.license.LicenseUpdater;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.event.DashboardEvent;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;

@SpringView(name="license")
@SideBarItem(sectionId="server-management", captionCode="UI_SUPPORT_LICENSE_HEADER", order=10)
public class LicenseView
extends Panel
implements View {
    @Autowired
    private ManagerHome managerHome;
    @Autowired
    private DownloadManager downloadManager;
    @Autowired
    private LicenseManager licenseManager;
    @Autowired
    private LicenseUpdater licenseUpdater;
    @Autowired
    private ClientService clientService;
    private final MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private final CssLayout root;
    private String serverID;
    private Box overviewBox;
    private Box actionBox;
    private Box errorBox;
    private static DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.SHORT).withLocale(UI.getCurrent().getLocale());
    private static DateTimeFormatter dateFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL).withLocale(UI.getCurrent().getLocale());

    public LicenseView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        this.setSizeFull();
        eventBus.publish((Object)this, (Object)new DashboardEvent.UpdateHeaderLabelEvent(this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_HEADER, new Object[0])));
        this.root = new CssLayout();
        this.root.setStyleName("licenseview");
        this.setContent((Component)this.root);
    }

    public String getCaption() {
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_HEADER, new Object[0]);
    }

    @PostConstruct
    private void init() {
        this.serverID = this.managerHome.getMetadata().getServerID();
        this.buildContent();
    }

    private void buildContent() {
        this.overviewBox = new OverviewBox();
        this.actionBox = new ActionBox();
        this.errorBox = new ErrorBox();
        this.root.addComponent((Component)this.overviewBox);
        this.root.addComponent((Component)this.actionBox);
        this.root.addComponent((Component)this.errorBox);
    }

    private static ConsoleWebMessages licenseErrorMessage(LicenseError.ErrorType type) {
        switch (type) {
            case UPDATED: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_UPDATED;
            }
            case NO_LICENSE: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_NO_LICENSE;
            }
            case DECRYPTION_ERROR: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_DECRYPTION_ERROR;
            }
            case SERVER_ID_ERROR: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_SERVER_ID_ERROR;
            }
            case NETWORK_ERROR: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_NETWORK_ERROR;
            }
            case SERVER_ERROR: {
                return ConsoleWebMessages.UI_SUPPORT_LICENSE_SERVER_ERROR;
            }
        }
        return null;
    }

    private Component spacer() {
        Label spacer = new Label();
        spacer.addStyleName("spacer");
        return spacer;
    }

    private String updateLicense(String licenseString) {
        if ((licenseString = licenseString.replaceAll("\n", "").trim()).length() == 0) {
            return "";
        }
        String[] licenseParts = licenseString.split("-");
        if (licenseParts.length != 2) {
            return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_INVALID, new Object[0]);
        }
        Base64.Decoder base64Decoder = Base64.getDecoder();
        try {
            base64Decoder.decode(licenseParts[0]);
            base64Decoder.decode(licenseParts[1]);
        }
        catch (IllegalArgumentException ex) {
            return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_INVALID, new Object[0]);
        }
        EncryptedLicense encryptedLicense = new EncryptedLicense();
        encryptedLicense.encryption_key = licenseParts[0];
        encryptedLicense.license = licenseParts[1];
        boolean success = this.licenseManager.setLicense(encryptedLicense);
        if (success) {
            return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_SUCCESS, new Object[0]);
        }
        return this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_ERROR, new Object[0]);
    }

    class DeletionPopup
    extends Popup {
        DeletionPopup() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_CONFIRM_DELETION_CAPTION, new String[0]);
            this.setWidth("642px");
            this.addContent(new Component[]{new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_CONFIRM_DELETION_TEXT, new Object[0]), ContentMode.HTML)});
            this.addButton(new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)ev -> {
                this.close();
                LicenseView.this.overviewBox.update();
            }), new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_CONFIRM_DELETION_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> {
                this.close();
                LicenseView.this.licenseManager.deleteLicense();
                LicenseView.this.overviewBox.update();
            }));
        }
    }

    class ManualEntryPopup
    extends Popup {
        private TextArea manualEntry;
        private Label manualEntryFeedback;

        ManualEntryPopup() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_CAPTION, "manual-license-entry");
            this.manualEntry = new TextArea();
            this.manualEntryFeedback = new Label();
            this.setWidth("642px");
            this.addContent(new Component[]{new Label(String.format(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_TEXT, new Object[0]), LicenseView.this.serverID), ContentMode.HTML), this.manualEntry, this.manualEntryFeedback, new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_MANUAL_ENTRY_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> {
                String feedback = LicenseView.this.updateLicense(this.manualEntry.getValue());
                this.manualEntryFeedback.setValue(feedback);
                LicenseView.this.overviewBox.update();
                LicenseView.this.errorBox.update();
            })});
        }

        @Override
        public void open() {
            super.open();
            this.manualEntry.focus();
        }
    }

    class DetailsPopup
    extends Popup {
        DetailsPopup() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_DETAILS_CAPTION, "license-details");
            this.setWidth("642px");
            int clientCount = LicenseView.this.clientService.findAll().size();
            License license = LicenseView.this.licenseManager.getLicense();
            this.addContent(new Component[]{new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_NAME, new Object[0])), new Label(license.getName()), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_EMAIL, new Object[0])), new Label(license.getEmail()), LicenseView.this.spacer(), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_COUNT, new Object[0])), new Label(clientCount + " / " + license.getCount()), new Label("Server ID"), new Label(LicenseView.this.serverID), LicenseView.this.spacer(), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_EXPIRATION_DATE, new Object[0])), new Label(license.getSoftExpiredDate().format(dateFormatter)), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_CREATED_DATE, new Object[0])), new Label(license.getCreatedDate().format(dateFormatter))});
            Label details = new Label(license.getDetails());
            details.addStyleName("details");
            this.addContent(new Component[]{details});
        }
    }

    public class Popup {
        private Window popup;
        private CssLayout contentLayout = new CssLayout();
        private CssLayout buttonsLayout = new CssLayout();
        private String width;

        public Popup(ConsoleWebMessages title_key, String ... styleNames) {
            this.contentLayout.addStyleName("content");
            this.contentLayout.addStyleNames(styleNames);
            this.buttonsLayout.addStyleName("buttons");
            CssLayout wrapper = new CssLayout(new Component[]{this.contentLayout, this.buttonsLayout});
            wrapper.addStyleName("wrapper");
            this.popup = new Window(LicenseView.this.mc.getMessage((Enum)title_key, new Object[0]), (Component)wrapper);
            this.popup.addStyleName("otc-popup");
            this.popup.setModal(true);
            this.popup.addCloseShortcut(27, new int[0]);
            this.popup.addCloseListener((Window.CloseListener & Serializable)ev -> UI.getCurrent().removeWindow(this.popup));
        }

        public void open() {
            if (this.buttonsLayout.getComponentCount() == 0) {
                this.buttonsLayout.addComponent((Component)new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CLOSE, new Object[0]), (Button.ClickListener & Serializable)ev -> this.popup.close()));
            }
            this.popup.setWindowMode(WindowMode.NORMAL);
            this.popup.setSizeUndefined();
            this.popup.setWidth(this.width);
            this.popup.center();
            UI.getCurrent().addWindow(this.popup);
        }

        public void close() {
            this.popup.close();
        }

        public void addContent(Component ... content) {
            this.contentLayout.addComponents(content);
        }

        public void addButton(Button ... buttons) {
            this.buttonsLayout.addComponents((Component[])buttons);
        }

        public void setWidth(String width) {
            this.width = width;
        }
    }

    class ErrorBox
    extends Box {
        ErrorBox() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_ERRORS_CAPTION, "errors");
        }

        @Override
        void build() {
            for (LicenseError error : LicenseView.this.licenseManager.getErrors()) {
                this.content.addComponents(new Component[]{new Label(error.datetime.format(dateTimeFormatter)), new Label(LicenseView.this.mc.getMessage((Enum)LicenseView.licenseErrorMessage(error.type), new Object[0]))});
            }
        }
    }

    class ActionBox
    extends Box {
        ActionBox() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_ACTIONS_CAPTION, "actions");
        }

        @Override
        void build() {
            this.content.addComponents(new Component[]{new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_UPDATE_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> {
                LicenseView.this.licenseUpdater.updateLicense(LicenseView.this.serverID);
                LicenseView.this.overviewBox.update();
                LicenseView.this.errorBox.update();
            }), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_UPDATE_BUTTON_HINT, new Object[0])), new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_ENTRY_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> new ManualEntryPopup().open()), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_ENTRY_BUTTON_HINT, new Object[0])), new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_DELETE_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> new DeletionPopup().open()), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_DELETE_BUTTON_HINT, new Object[0]))});
        }
    }

    class OverviewBox
    extends Box {
        OverviewBox() {
            super(ConsoleWebMessages.UI_SUPPORT_LICENSE_OVERVIEW_CAPTION, "overview");
        }

        @Override
        void build() {
            int clientCount = LicenseView.this.clientService.findAll().size();
            License license = LicenseView.this.licenseManager.getLicense();
            if (license != null) {
                this.content.addComponents(new Component[]{new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_NAME, new Object[0])), new Label(license.getName()), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_COUNT, new Object[0])), new Label(clientCount + " / " + license.getCount()), new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_FIELD_EXPIRATION_DATE, new Object[0])), new Label(license.getSoftExpiredDate().format(dateFormatter))});
            } else {
                Label noLicense = new Label(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_NOT_INSTALLED, new Object[0]));
                noLicense.addStyleName("nolicense");
                this.content.addComponent((Component)noLicense);
            }
            this.content.addComponents(new Component[]{new Label("Server ID"), new Label(LicenseView.this.serverID)});
            if (license != null) {
                this.content.addComponent((Component)new Button(LicenseView.this.mc.getMessage((Enum)ConsoleWebMessages.UI_SUPPORT_LICENSE_OVERVIEW_BUTTON, new Object[0]), (Button.ClickListener & Serializable)ev -> new DetailsPopup().open()));
            }
        }
    }

    abstract class Box
    extends CssLayout {
        CssLayout content = new CssLayout();

        Box(ConsoleWebMessages title_key, String styleName) {
            this.addStyleName("box");
            Label title = new Label(LicenseView.this.mc.getMessage((Enum)title_key, new Object[0]));
            title.addStyleName("title");
            this.content.addStyleName("content");
            this.content.addStyleName(styleName);
            this.addComponents(new Component[]{title, this.content});
            this.update();
        }

        void update() {
            this.content.removeAllComponents();
            this.build();
        }

        abstract void build();
    }
}

