/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.support;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.Binder;
import com.vaadin.data.Converter;
import com.vaadin.data.HasValue;
import com.vaadin.data.Validator;
import com.vaadin.data.validator.IntegerRangeValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CustomComponent;
import com.vaadin.ui.FormLayout;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.PasswordField;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.openthinclient.manager.util.http.config.NetworkConfiguration;
import org.openthinclient.web.converter.StringToIntegerConverter;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.support.HostnameValidator;
import org.vaadin.viritin.button.MButton;

public class ProxyConfigurationForm
extends CustomComponent {
    private final TextField hostField;
    private final TextField portField;
    private final TextField userField;
    private final PasswordField passwordField;
    private final CheckBox authenticationCheckbox;
    private final CheckBox useProxyCheckbox;
    private final HorizontalLayout buttonLine = new HorizontalLayout();
    private final Binder<NetworkConfiguration.ProxyConfiguration> binder;
    private final NetworkConfiguration.ProxyConfiguration proxyConfiguration;

    public ProxyConfigurationForm(NetworkConfiguration.ProxyConfiguration proxyConfiguration) {
        MessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.proxyConfiguration = proxyConfiguration;
        this.authenticationCheckbox = new CheckBox(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_CONNECTION_AUTH, new Object[0]));
        this.authenticationCheckbox.setValue(Boolean.valueOf(StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{this.proxyConfiguration.getUser()})));
        this.binder = new Binder();
        this.useProxyCheckbox = new CheckBox(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_ENABLED, new Object[0]));
        this.userField = new TextField(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_USERNAME, new Object[0]));
        this.userField.setPlaceholder(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_USERNAME, new Object[0]));
        this.passwordField = new PasswordField(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_PASSWORD, new Object[0]));
        this.passwordField.setPlaceholder(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_PASSWORD, new Object[0]));
        this.binder.forField((HasValue)this.useProxyCheckbox).bind(NetworkConfiguration.ProxyConfiguration::isEnabled, NetworkConfiguration.ProxyConfiguration::setEnabled);
        this.binder.forField((HasValue)this.userField).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getUser, NetworkConfiguration.ProxyConfiguration::setUser);
        this.binder.forField((HasValue)this.passwordField).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getPassword, NetworkConfiguration.ProxyConfiguration::setPassword);
        this.hostField = new TextField(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_HOSTNAME, new Object[0]));
        this.hostField.setPlaceholder("proxy.example.com");
        this.binder.forField((HasValue)this.hostField).withValidator((Validator)new StringLengthValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_CONNECTION_HOST_MISSING, new Object[0]), Integer.valueOf(1), null)).withValidator((Validator)new HostnameValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_CONNECTION_HOST_INVALID, new Object[0]))).withNullRepresentation((Object)"").bind(NetworkConfiguration.ProxyConfiguration::getHost, NetworkConfiguration.ProxyConfiguration::setHost);
        this.portField = new TextField(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_PORT, new Object[0]));
        this.binder.forField((HasValue)this.portField).withConverter((Converter)new StringToIntegerConverter(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_CONNECTION_PORT_INVALID, new Object[0]))).withValidator((Validator)new IntegerRangeValidator(mc.getMessage((Enum)ConsoleWebMessages.UI_CONFIGURATION_PROXY_CONNECTION_PORT_INVALID, new Object[0]), Integer.valueOf(1), Integer.valueOf(65535))).bind(NetworkConfiguration.ProxyConfiguration::getPort, NetworkConfiguration.ProxyConfiguration::setPort);
        this.binder.readBean((Object)proxyConfiguration);
        FormLayout form = new FormLayout();
        form.addComponent((Component)this.useProxyCheckbox);
        form.addComponent((Component)this.hostField);
        form.addComponent((Component)this.portField);
        form.addComponent((Component)this.authenticationCheckbox);
        form.addComponent((Component)this.userField);
        form.addComponent((Component)this.passwordField);
        form.addComponent((Component)this.buttonLine);
        this.buttonLine.addComponent((Component)new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_RESET, new Object[0])).withListener((Button.ClickListener & Serializable)e -> this.resetValues()));
        this.buttonLine.addComponent((Component)new MButton(mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0])).withListener((Button.ClickListener & Serializable)e -> this.saveValues()));
        this.authenticationCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateEnabledState());
        this.useProxyCheckbox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> this.updateEnabledState());
        this.updateEnabledState();
        this.setCompositionRoot((Component)form);
    }

    public void saveValues() {
    }

    private void updateEnabledState() {
        this.hostField.setEnabled(this.useProxyCheckbox.getValue().booleanValue());
        this.portField.setEnabled(this.useProxyCheckbox.getValue().booleanValue());
        this.authenticationCheckbox.setEnabled(this.useProxyCheckbox.getValue().booleanValue());
        if (!this.useProxyCheckbox.getValue().booleanValue()) {
            this.authenticationCheckbox.setValue(this.useProxyCheckbox.getValue());
        }
        this.userField.setEnabled(this.authenticationCheckbox.getValue().booleanValue());
        this.passwordField.setEnabled(this.authenticationCheckbox.getValue().booleanValue());
    }

    public void commit() {
        if (!this.authenticationCheckbox.getValue().booleanValue()) {
            this.userField.setValue("");
            this.passwordField.setValue("");
        }
        this.binder.writeBeanIfValid((Object)this.proxyConfiguration);
    }

    public void resetValues() {
        this.binder.readBean((Object)this.proxyConfiguration);
        this.authenticationCheckbox.setValue(Boolean.valueOf(this.proxyConfiguration.getUser() != null));
    }
}

