/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ProfilesListOverviewPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;
import org.vaadin.viritin.button.MButton;

@SpringView(name="application_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_APPLICATION_HEADER", order=30)
@ThemeIcon(value="icon/application.svg")
public final class ApplicationView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationView.class);
    public static final String NAME = "application_view";
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private ClientService clientService;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public ApplicationView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_APPLICATION_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    public void setup() {
        this.showCreateApplicationAction();
        Set applicationGroups = Collections.EMPTY_SET;
        try {
            applicationGroups = this.applicationGroupService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find application-groups: " + e.getMessage());
        }
        ProfilesListOverviewPanelPresenter agpp = this.addOverviewItemlistPanel(ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, applicationGroups);
        agpp.addNewButtonClickHandler((Button.ClickListener & Serializable)event -> {
            VerticalLayout content = new VerticalLayout();
            Window window = new Window(null, (Component)content);
            window.setModal(true);
            window.setPositionX(200);
            window.setPositionY(50);
            window.setCaption("Anwendungsgruppe erstellen");
            content.addComponent((Component)new Label("Legen Sie bitte den Anwendungsgruppenname fest:"));
            TextField input = new TextField();
            content.addComponent((Component)input);
            HorizontalLayout hl = new HorizontalLayout();
            hl.addComponents(new Component[]{new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)event1 -> window.close()), new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]), (Button.ClickListener & Serializable)event1 -> {
                ApplicationGroup byName = (ApplicationGroup)this.applicationGroupService.findByName(input.getValue());
                if (byName == null) {
                    ApplicationGroup ag = new ApplicationGroup();
                    ag.setName(input.getValue());
                    this.applicationGroupService.save((DirectoryObject)ag);
                    ListDataProvider dataProvider = DataProvider.ofCollection((Collection)this.applicationGroupService.findAll());
                    dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
                    agpp.setDataProvider((ListDataProvider<DirectoryObject>)dataProvider);
                    window.close();
                    UI.getCurrent().removeWindow(window);
                } else {
                    content.addComponent((Component)new Label("Der Name ist schon vergeben."));
                }
            })});
            content.addComponent((Component)hl);
            window.setContent((Component)content);
            UI.getCurrent().addWindow(window);
        });
        agpp.setItemsSupplier(() -> this.applicationGroupService.findAll());
        agpp.setItemButtonClickedConsumer(null);
        this.addOverviewItemlistPanel(ConsoleWebMessages.UI_APPLICATION_HEADER, this.getAllItems());
    }

    @Override
    public Set getAllItems() {
        try {
            return this.applicationService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Application.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(Application.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        String type = meta.getProperty("type").get().getConfiguration().getValue();
        ProfilePanel profilePanel = new ProfilePanel(profile.getName() + " (" + type + ")", profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        Profile profile = (Profile)item;
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Set allClients = this.clientService.findAll();
        Set members = ((Application)profile).getMembers();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]), allClients, Client.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allClients, Client.class));
        Set allUsers = this.userService.findAll();
        refPresenter.showReference(members, this.mc.getMessage((Enum)ConsoleWebMessages.UI_USER_HEADER, new Object[0]), allUsers, User.class, values -> this.saveReference((DirectoryObject)profile, (List<Item>)values, allUsers, User.class));
        Set allApplicationGroups = this.applicationGroupService.findAll();
        Set applicationGroupsByApplication = allApplicationGroups.stream().filter(ag -> ag.getApplications().contains(profile)).collect(Collectors.toSet());
        refPresenter.showReference(applicationGroupsByApplication, this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveApplicationGroupReference((Application)profile, (List<Item>)values), this.getApplicationsForApplicationGroupFunction(), false);
        return referencesPanel;
    }

    private void saveApplicationGroupReference(Application application, List<Item> values) {
        Set oldValues = ((Application)this.applicationService.findByName(application.getName())).getMembers();
        LOGGER.debug("Old application-groups: {}", (Object)oldValues);
        oldValues.forEach(oldItem -> {
            if (values.stream().anyMatch(a -> a.getName().equals(oldItem.getName()))) {
                LOGGER.info("Keep oldValue as member: " + oldItem);
            } else {
                LOGGER.info("Remove oldValue from application: " + oldItem);
                if (application.getMembers().contains(oldItem)) {
                    application.getMembers().remove(oldItem);
                    this.applicationService.save((DirectoryObject)application);
                } else {
                    LOGGER.info("ApplicationGroup (to remove) not found in members of " + oldItem);
                }
            }
        });
        values.forEach(newValue -> {
            ApplicationGroup applicationGroup1 = (ApplicationGroup)this.applicationGroupService.findByName(newValue.getName());
            if (applicationGroup1 != null) {
                if (!oldValues.contains(applicationGroup1)) {
                    LOGGER.info("Add ApplicationGroup {} as member of {}", (Object)applicationGroup1.getName(), (Object)application);
                    application.getMembers().add(applicationGroup1);
                    this.applicationService.save((DirectoryObject)application);
                }
            } else {
                LOGGER.info("ApplicationGroup not found for " + newValue);
            }
        });
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String profileName) {
        return (T)this.applicationService.findByName(profileName);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.applicationService.save((DirectoryObject)((Application)profile));
    }

    private Function<Item, List<Item>> getApplicationsForApplicationGroupFunction() {
        return appGroup -> {
            Optional<ApplicationGroup> first = this.applicationGroupService.findAll().stream().filter(ag -> ag.getName().equals(appGroup.getName())).findFirst();
            if (first.isPresent()) {
                ApplicationGroup applicationGroup = first.get();
                LOGGER.info("ApplicationGroup {} with applications {} loaded.", (Object)applicationGroup.getName(), (Object)applicationGroup.getApplications());
                Stream<Application> stream = applicationGroup.getApplications().stream().sorted(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase));
                return stream.map(m -> new Item(m.getName(), Item.Type.APPLICATION)).collect(Collectors.toList());
            }
            return new ArrayList();
        };
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

