/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.ValidationResult;
import com.vaadin.data.ValueContext;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.data.validator.AbstractValidator;
import com.vaadin.data.validator.RegexpValidator;
import com.vaadin.data.validator.StringLengthValidator;
import com.vaadin.navigator.ViewChangeListener;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Application;
import org.openthinclient.common.model.ApplicationGroup;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.User;
import org.openthinclient.common.model.UserGroup;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ApplicationGroupService;
import org.openthinclient.common.model.service.ApplicationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.common.model.service.UserGroupService;
import org.openthinclient.common.model.service.UserService;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.model.ItemConfiguration;
import org.openthinclient.web.thinclient.presenter.DirectoryObjectPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ProfilesListOverviewPanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;
import org.vaadin.viritin.button.MButton;

@SpringView(name="user_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_USER_HEADER", order=40)
@ThemeIcon(value="icon/user.svg")
public final class UserView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserView.class);
    public static final String NAME = "user_view";
    @Autowired
    private PrinterService printerService;
    @Autowired
    private UserService userService;
    @Autowired
    private UserGroupService userGroupService;
    @Autowired
    private ApplicationGroupService applicationGroupService;
    @Autowired
    private ApplicationService applicationService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());

    public UserView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_USER_HEADER, eventBus, notificationService);
    }

    @PostConstruct
    private void setup() {
        this.showCreateUserAction();
        Set userGroups = Collections.EMPTY_SET;
        try {
            userGroups = this.userGroupService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find userGroups: " + e.getMessage());
        }
        ProfilesListOverviewPanelPresenter agpp = this.addOverviewItemlistPanel(ConsoleWebMessages.UI_USERGROUP_HEADER, userGroups);
        agpp.addNewButtonClickHandler((Button.ClickListener & Serializable)event -> {
            VerticalLayout content = new VerticalLayout();
            Window window = new Window(null, (Component)content);
            window.setModal(true);
            window.setPositionX(200);
            window.setPositionY(50);
            window.setCaption("Usergruppe erstellen");
            content.addComponent((Component)new Label("Legen Sie bitte den Usergruppenname fest:"));
            TextField input = new TextField();
            content.addComponent((Component)input);
            HorizontalLayout hl = new HorizontalLayout();
            hl.addComponents(new Component[]{new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CANCEL, new Object[0]), (Button.ClickListener & Serializable)event1 -> window.close()), new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_SAVE, new Object[0]), (Button.ClickListener & Serializable)event1 -> {
                UserGroup byName = (UserGroup)this.userGroupService.findByName(input.getValue());
                if (byName == null) {
                    UserGroup ug = new UserGroup();
                    ug.setName(input.getValue());
                    this.userGroupService.save((DirectoryObject)ug);
                    ListDataProvider dataProvider = DataProvider.ofCollection((Collection)this.userGroupService.findAll());
                    dataProvider.setSortComparator(Comparator.comparing(DirectoryObject::getName, String::compareToIgnoreCase)::compare);
                    agpp.setDataProvider((ListDataProvider<DirectoryObject>)dataProvider);
                    window.close();
                    UI.getCurrent().removeWindow(window);
                } else {
                    content.addComponent((Component)new Label("Der Name ist schon vergeben."));
                }
            })});
            content.addComponent((Component)hl);
            window.setContent((Component)content);
            UI.getCurrent().addWindow(window);
        });
        agpp.setItemsSupplier(() -> this.userGroupService.findAll());
        agpp.setItemButtonClickedConsumer(null);
        this.addOverviewItemlistPanel(ConsoleWebMessages.UI_USER_HEADER, this.getAllItems());
    }

    @Override
    public Set getAllItems() {
        try {
            return this.userService.findAll().stream().filter(user -> !user.getName().equals("administrator")).collect(Collectors.toSet());
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(User.class, schemaName);
    }

    @Override
    public String[] getSchemaNames() {
        return this.schemaProvider.getSchemaNames(User.class);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) {
        ProfilePanel profilePanel = this.createUserProfilePanel((User)directoryObject, false);
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        User user = (User)item;
        Set allUserGroups = this.userGroupService.findAll();
        refPresenter.showReference(user.getUserGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERGROUP_HEADER, new Object[0]), allUserGroups, UserGroup.class, values -> this.saveReference(item, (List<Item>)values, allUserGroups, UserGroup.class));
        Set allApplicationGroups = this.applicationGroupService.findAll();
        refPresenter.showReference(user.getApplicationGroups(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATIONGROUP_HEADER, new Object[0]), allApplicationGroups, ApplicationGroup.class, values -> this.saveReference(item, (List<Item>)values, allApplicationGroups, ApplicationGroup.class));
        Set allApplicatios = this.applicationService.findAll();
        refPresenter.showReference(user.getApplications(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_APPLICATION_HEADER, new Object[0]), allApplicatios, Application.class, values -> this.saveReference(item, (List<Item>)values, allApplicatios, Application.class));
        Set allPrinters = this.printerService.findAll();
        refPresenter.showReference(user.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), allPrinters, Printer.class, values -> this.saveReference(item, (List<Item>)values, allPrinters, Printer.class));
        return referencesPanel;
    }

    private OtcPropertyGroup createUserMetadataPropertyGroup(User user) {
        OtcPropertyGroup configuration = new OtcPropertyGroup(null, new OtcProperty[0]);
        configuration.setDisplayHeaderLabel(false);
        OtcTextProperty name = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_LOGIN_USERNAME, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_TIP, new Object[0]), "name", user.getName());
        ItemConfiguration nameConfiguration = new ItemConfiguration("name", user.getName());
        nameConfiguration.addValidator((AbstractValidator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_LENGTH, new Object[0]), Integer.valueOf(1), null));
        nameConfiguration.addValidator((AbstractValidator)new RegexpValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_FILEBROWSER_SUBWINDOW_CREATEFOLDER_VALIDATION_REGEX, new Object[0]), "[a-zA-Z0-9]+"));
        nameConfiguration.addValidator(new AbstractValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_USERNAME_VALIDATOR_NAME_EXISTS, new Object[0])){

            public ValidationResult apply(Object value, ValueContext context) {
                Optional optional = UserView.this.userService.findBySAMAccountName(value.toString());
                return this.toResult(value, !optional.isPresent());
            }

            public Object apply(Object o, Object o2) {
                return null;
            }
        });
        name.setConfiguration(nameConfiguration);
        configuration.addProperty(name);
        OtcTextProperty desc = new OtcTextProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DESCRIPTION_LABEL, new Object[0]), null, "description", user.getDescription());
        ItemConfiguration descConfig = new ItemConfiguration("description", user.getDescription());
        desc.setConfiguration(descConfig);
        configuration.addProperty(desc);
        String pwdValue = user.getUserPassword() != null ? new String(user.getUserPassword()) : null;
        OtcPasswordProperty pwd = new OtcPasswordProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_LABEL, new Object[0]), this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_VALIDATOR_LENGTH, new Object[0]), "password", pwdValue);
        final ItemConfiguration pwdConfig = new ItemConfiguration("password", pwdValue);
        pwdConfig.addValidator((AbstractValidator)new StringLengthValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_VALIDATOR_LENGTH, new Object[0]), Integer.valueOf(1), null));
        pwd.setConfiguration(pwdConfig);
        configuration.addProperty(pwd);
        OtcPasswordProperty pwdRetype = new OtcPasswordProperty(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PASSWORD_RETYPE_LABEL, new Object[0]), null, "passwordRetype", pwdValue);
        ItemConfiguration pwdRetypeConfig = new ItemConfiguration("passwordRetype", pwdValue);
        pwdRetypeConfig.addValidator(new AbstractValidator(this.mc.getMessage((Enum)ConsoleWebMessages.UI_USERS_PASSWORD_RETYPE_VALIDATOR, new Object[0])){

            public ValidationResult apply(Object value, ValueContext context) {
                return this.toResult(value, pwdConfig.getValue() != null && pwdConfig.getValue().equals(value));
            }

            public Object apply(Object o, Object o2) {
                return null;
            }
        });
        pwdRetype.setConfiguration(pwdRetypeConfig);
        configuration.addProperty(pwdRetype);
        return configuration;
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.userService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.userService.save((DirectoryObject)((User)profile));
    }

    public void showProfileMetadata(User profile) {
        ProfilePanel profilePanel = this.createUserProfilePanel(profile, true);
        this.showProfileMetadataPanel(profilePanel);
    }

    protected ProfilePanel createUserProfilePanel(User profile, boolean userIsNew) {
        OtcPropertyGroup propertyGroup = this.createUserMetadataPropertyGroup(profile);
        if (!userIsNew) {
            propertyGroup.getProperty("name").ifPresent(otcProperty -> {
                OtcTextProperty name = (OtcTextProperty)otcProperty;
                name.getConfiguration().getValidators().clear();
                name.getConfiguration().disable();
            });
        }
        ProfilePanel profilePanel = new ProfilePanel(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_NEW_PROFILE_HEADER, new Object[0]), profile.getClass());
        DirectoryObjectPanelPresenter ppp = new DirectoryObjectPanelPresenter(this, profilePanel, (DirectoryObject)profile);
        ppp.setItemGroups(Arrays.asList(propertyGroup, new OtcPropertyGroup(null, null)));
        if (userIsNew) {
            ppp.hideCopyButton();
            ppp.hideDeleteButton();
        }
        ppp.onValuesWritten(profilePanel1 -> ppp.getItemGroupPanels().forEach(igp -> {
            igp.propertyComponents().forEach(propertyComponent -> {
                OtcProperty bean = (OtcProperty)propertyComponent.getBinder().getBean();
                String key = bean.getKey();
                String value = bean.getConfiguration().getValue();
                switch (key) {
                    case "name": {
                        profile.setName(value);
                        break;
                    }
                    case "description": {
                        profile.setDescription(value);
                        break;
                    }
                    case "password": {
                        profile.setUserPassword(value.getBytes());
                        break;
                    }
                    case "passwordRetype": {
                        profile.setVerifyPassword(value);
                    }
                }
            });
            boolean success = this.saveProfile((DirectoryObject)profile, ppp);
            if (success) {
                this.selectItem((DirectoryObject)profile);
                if (userIsNew) {
                    this.navigateTo((DirectoryObject)profile);
                }
            }
        }));
        return profilePanel;
    }

    @Override
    public void enter(ViewChangeListener.ViewChangeEvent event) {
        if (event.getParameters() != null) {
            String[] params = event.getParameters().split("/");
            if (params.length == 1 && params[0].equals("create")) {
                switch (event.getViewName()) {
                    case "user_view": {
                        this.showProfileMetadata(new User());
                    }
                }
            } else if (params.length == 1 && params[0].length() > 0) {
                Object profile = this.getFreshProfile(params[0]);
                if (profile != null) {
                    String message = this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_COPY_TARGET_NAME, new Object[]{""}).trim();
                    boolean userIsNew = profile.getName().indexOf(message) == 0;
                    ProfilePanel profilePanel = this.createUserProfilePanel((User)profile, userIsNew);
                    ProfileReferencesPanel profileReferencesPanel = this.createReferencesPanel((DirectoryObject)profile);
                    this.displayProfilePanel(profilePanel, profileReferencesPanel);
                } else {
                    LOGGER.info("No profile found for name '" + params[0] + "'.");
                }
            }
        }
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }
}

