/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.NativeButton;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.component.CollapseablePanel;
import org.openthinclient.web.thinclient.component.PropertyComponent;
import org.openthinclient.web.thinclient.component.PropertyPasswordField;
import org.openthinclient.web.thinclient.component.PropertySelect;
import org.openthinclient.web.thinclient.component.PropertyTextField;
import org.openthinclient.web.thinclient.component.PropertyToggleSlider;
import org.openthinclient.web.thinclient.property.OtcBooleanProperty;
import org.openthinclient.web.thinclient.property.OtcOptionProperty;
import org.openthinclient.web.thinclient.property.OtcPasswordProperty;
import org.openthinclient.web.thinclient.property.OtcProperty;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.thinclient.property.OtcTextProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItemGroupPanel
extends VerticalLayout
implements CollapseablePanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ItemGroupPanel.class);
    private final IMessageConveyor mc;
    private NativeButton head;
    boolean itemsVisible = false;
    private Map<PropertyComponent, Component> propertyComponents = new HashMap<PropertyComponent, Component>();
    private int itemStartIndex = 1;

    public ItemGroupPanel(OtcPropertyGroup propertyGroup) {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setMargin(false);
        this.setSpacing(false);
        this.setStyleName("itemGroupPanel");
        this.head = new NativeButton(propertyGroup.getLabel() != null ? propertyGroup.getLabel() : this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_SETTINGS, new Object[0]));
        this.head.setStyleName("headButton");
        this.head.setSizeFull();
        if (propertyGroup.isDisplayHeaderLabel()) {
            this.addComponent((Component)this.head);
        } else {
            this.addStyleName("headButtonHidden");
            this.itemStartIndex = 0;
        }
        propertyGroup.getOtcProperties().forEach(p -> this.addProperty((OtcProperty)p, 0));
        propertyGroup.getGroups().forEach(pg -> this.addProperty((OtcPropertyGroup)pg, 1));
        if (propertyGroup.isCollapseOnDisplay()) {
            this.collapseItems();
        }
    }

    public ItemGroupPanel(List<OtcProperty> otcProperties) {
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
        this.setMargin(false);
        this.setSpacing(false);
        this.setStyleName("itemGroupPanel");
        this.head = new NativeButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_SETTINGS, new Object[0]));
        this.head.setStyleName("headButton");
        this.head.setSizeFull();
        this.addStyleName("headButtonHidden");
        this.itemStartIndex = 0;
        otcProperties.forEach(p -> this.addProperty((OtcProperty)p, 0));
    }

    public void addProperty(OtcProperty property, int level) {
        HorizontalLayout proprow = new HorizontalLayout();
        proprow.setSpacing(false);
        proprow.setStyleName("property-" + level);
        Label propertyLabel = new Label(property.getLabel());
        propertyLabel.setStyleName("propertyLabel");
        proprow.addComponent((Component)propertyLabel);
        PropertyComponent pc = this.createPropertyComponent(property);
        proprow.addComponent((Component)pc);
        if (property.getTip() != null) {
            Button showSettingInfoButton = new Button(null, (Resource)VaadinIcons.INFO_CIRCLE_O);
            showSettingInfoButton.setStyleName("borderless-colored");
            Label currentSettingInfo = new Label(property.getTip());
            currentSettingInfo.setStyleName("propertyInformationLabel");
            proprow.addComponents(new Component[]{showSettingInfoButton, currentSettingInfo});
        }
        Label validationLabel = new Label(property.getLabel());
        validationLabel.setStyleName("validationLabel");
        proprow.addComponent((Component)validationLabel);
        this.propertyComponents.put(pc, (Component)validationLabel);
        this.addComponent((Component)proprow);
    }

    public void addProperty(OtcPropertyGroup propertyGroup, int level) {
        if (propertyGroup.getLabel() != null) {
            Label groupLabel = new Label(propertyGroup.getLabel());
            groupLabel.setStyleName("propertyGroupLabel-" + level);
            this.addComponent((Component)groupLabel);
        }
        propertyGroup.getOtcProperties().forEach(p -> this.addProperty((OtcProperty)p, level));
        propertyGroup.getGroups().forEach(pg -> this.addProperty((OtcPropertyGroup)pg, level + 1));
    }

    @Override
    public void collapseItems() {
        this.itemsVisible = false;
        this.head.removeStyleName("itemsVisible");
        int componentCount = this.getComponentCount();
        for (int i = this.itemStartIndex; i < componentCount; ++i) {
            this.getComponent(i).setVisible(false);
        }
    }

    public void expandItems() {
        this.itemsVisible = true;
        this.head.addStyleName("itemsVisible");
        int componentCount = this.getComponentCount();
        for (int i = this.itemStartIndex; i < componentCount; ++i) {
            this.getComponent(i).setVisible(true);
        }
    }

    private PropertyComponent createPropertyComponent(OtcProperty property) {
        if (property instanceof OtcBooleanProperty) {
            PropertyToggleSlider<OtcBooleanProperty> field = new PropertyToggleSlider<OtcBooleanProperty>((OtcBooleanProperty)property);
            return field;
        }
        if (property instanceof OtcPasswordProperty) {
            PropertyPasswordField<OtcPasswordProperty> field = new PropertyPasswordField<OtcPasswordProperty>((OtcPasswordProperty)property);
            return field;
        }
        if (property instanceof OtcTextProperty) {
            PropertyTextField<OtcTextProperty> field = new PropertyTextField<OtcTextProperty>((OtcTextProperty)property);
            return field;
        }
        if (property instanceof OtcOptionProperty) {
            PropertySelect<OtcOptionProperty> field = new PropertySelect<OtcOptionProperty>((OtcOptionProperty)property);
            return field;
        }
        throw new RuntimeException("Unknown Property-Type: " + property);
    }

    public List<PropertyComponent> propertyComponents() {
        return new ArrayList<PropertyComponent>(this.propertyComponents.keySet());
    }

    public boolean isItemsVisible() {
        return this.itemsVisible;
    }

    public NativeButton getHead() {
        return this.head;
    }

    public Optional<PropertyComponent> getPropertyComponent(String key) {
        return this.propertyComponents.keySet().stream().filter(pc -> ((OtcProperty)pc.getBinder().getBean()).getKey().equals(key)).findFirst();
    }

    public void setValidationMessage(String key, String message) {
        this.getPropertyComponent(key).ifPresent(propertyComponent -> {
            Label component = (Label)this.propertyComponents.get(propertyComponent);
            component.setValue(message);
            component.setVisible(true);
        });
    }

    public void emptyValidationMessages() {
        this.propertyComponents.forEach((propertyComponent, component) -> component.setVisible(false));
    }
}

