/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.ValueProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.shared.ui.grid.HeightMode;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Panel;
import com.vaadin.ui.StyleGenerator;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.components.grid.MultiSelectionModel;
import java.io.Serializable;
import java.util.function.Consumer;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;

public class ProfilesListOverviewPanel
extends Panel {
    private IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private CheckBox selectAll;
    private Grid<DirectoryObject> itemGrid;
    private Button addNew;
    private Button deleteProfileAction;
    private Consumer<DirectoryObject> itemButtonClickedConsumer = null;
    private Grid.Column<DirectoryObject, Button> itemBtn;

    public ProfilesListOverviewPanel(ConsoleWebMessages i18nTitleKey) {
        this.setCaption(this.mc.getMessage((Enum)i18nTitleKey, new Object[0]));
        this.addStyleName("overviewPanel");
        this.setVisible(false);
        CssLayout layout = new CssLayout();
        layout.setSizeFull();
        this.setContent((Component)layout);
        CssLayout filterLine = new CssLayout();
        filterLine.addStyleNames(new String[]{"filterLine"});
        TextField filter = new TextField();
        filter.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMT, new Object[0]));
        filter.addValueChangeListener(this::onFilterTextChange);
        filterLine.addComponent((Component)filter);
        layout.addComponent((Component)filterLine);
        HorizontalLayout actionLine = new HorizontalLayout();
        actionLine.addStyleNames(new String[]{"actionLine"});
        this.selectAll = new CheckBox(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_SELECT_ALL, new Object[0]));
        this.selectAll.addValueChangeListener(this::selectAllItems);
        actionLine.addComponent((Component)this.selectAll);
        this.addNew = new Button("");
        this.addNew.setIcon((Resource)VaadinIcons.PLUS_CIRCLE_O);
        this.addNew.addStyleName("borderless-colored");
        this.addNew.addStyleName("small");
        this.addNew.addStyleName("icon-only");
        this.addNew.addStyleName("addNew");
        actionLine.addComponent((Component)this.addNew);
        this.deleteProfileAction = new Button();
        this.deleteProfileAction.setDescription(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PROFILE_PANEL_BUTTON_ALT_TEXT_DELETE, new Object[0]));
        this.deleteProfileAction.setIcon((Resource)VaadinIcons.CLOSE_CIRCLE_O);
        this.deleteProfileAction.addStyleName("borderless-colored");
        this.deleteProfileAction.addStyleName("small");
        this.deleteProfileAction.addStyleName("icon-only");
        this.deleteProfileAction.addStyleName("deleteProfile");
        actionLine.addComponent((Component)this.deleteProfileAction);
        layout.addComponent((Component)actionLine);
        CssLayout gridWrapper = new CssLayout();
        gridWrapper.addStyleNames(new String[]{"table"});
        this.itemGrid = new Grid();
        this.itemGrid.setSelectionMode(Grid.SelectionMode.MULTI);
        this.itemGrid.addColumn(DirectoryObject::getName);
        this.itemBtn = this.itemGrid.addComponentColumn((ValueProvider & Serializable)dirObj -> {
            Button button = new Button();
            button.setIcon((Resource)VaadinIcons.COG_O);
            button.addStyleName("borderless-colored");
            button.addStyleName("small");
            button.addStyleName("icon-only");
            button.addClickListener((Button.ClickListener & Serializable)e -> this.itemButtonClicked((DirectoryObject)dirObj));
            return button;
        });
        this.itemGrid.removeHeaderRow(0);
        this.itemGrid.setSizeFull();
        this.itemGrid.setHeightMode(HeightMode.UNDEFINED);
        this.itemGrid.setStyleGenerator((StyleGenerator & Serializable)profile -> profile.getClass().getSimpleName());
        gridWrapper.addComponent(this.itemGrid);
        layout.addComponent((Component)gridWrapper);
    }

    private void itemButtonClicked(DirectoryObject dirObj) {
        if (this.itemButtonClickedConsumer != null) {
            this.itemButtonClickedConsumer.accept(dirObj);
        }
    }

    private void selectAllItems(HasValue.ValueChangeEvent<Boolean> booleanValueChangeEvent) {
        MultiSelectionModel selectionModel = (MultiSelectionModel)this.itemGrid.getSelectionModel();
        if (((Boolean)booleanValueChangeEvent.getValue()).booleanValue()) {
            selectionModel.selectAll();
        } else {
            selectionModel.deselectAll();
        }
    }

    private void onFilterTextChange(HasValue.ValueChangeEvent<String> event) {
        ListDataProvider dataProvider = (ListDataProvider)this.itemGrid.getDataProvider();
        long groupHeader = dataProvider.getItems().stream().filter(i -> i.getClass().equals(ProfilePropertiesBuilder.MenuGroupProfile.class)).count();
        dataProvider.setFilter((SerializablePredicate & Serializable)directoryObject -> {
            if (directoryObject instanceof ProfilePropertiesBuilder.MenuGroupProfile) {
                return true;
            }
            return this.caseInsensitiveContains(directoryObject.getName(), (String)event.getValue());
        });
    }

    private Boolean caseInsensitiveContains(String where, String what) {
        return where.toLowerCase().contains(what.toLowerCase());
    }

    public Grid<DirectoryObject> getItemGrid() {
        return this.itemGrid;
    }

    public Button getAddButton() {
        return this.addNew;
    }

    public Button getDeleteButton() {
        return this.deleteProfileAction;
    }

    public CheckBox getCheckBox() {
        return this.selectAll;
    }

    public void setItemButtonClickedConsumer(Consumer<DirectoryObject> itemButtonClickedConsumer) {
        this.itemButtonClickedConsumer = itemButtonClickedConsumer;
        if (itemButtonClickedConsumer == null && this.itemBtn != null) {
            this.itemGrid.removeColumn(this.itemBtn);
        }
    }
}

