/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.presenter;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.data.provider.DataProvider;
import com.vaadin.data.provider.ListDataProvider;
import com.vaadin.server.SerializablePredicate;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.Grid;
import com.vaadin.ui.HorizontalLayout;
import com.vaadin.ui.Label;
import com.vaadin.ui.TextField;
import com.vaadin.ui.UI;
import com.vaadin.ui.VerticalLayout;
import com.vaadin.ui.Window;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.component.ItemButtonComponent;
import org.openthinclient.web.thinclient.component.ReferencesComponent;
import org.openthinclient.web.thinclient.model.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReferencesComponentPresenter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferencesComponentPresenter.class);
    private IMessageConveyor mc = new MessageConveyor(UI.getCurrent().getLocale());
    private ReferencesComponent view;
    private Consumer<List<Item>> profileReferenceChanged;
    ListDataProvider<Item> itemListDataProvider;
    private List<Item> currentReferencedItems;
    private Function<Item, List<Item>> memberSupplier;
    private boolean isReadOnly;

    public ReferencesComponentPresenter(ReferencesComponent view, List<Item> allItems, List<Item> referencedItems, boolean isReadOnly) {
        this.view = view;
        this.currentReferencedItems = referencedItems;
        this.isReadOnly = isReadOnly;
        this.view.getMultiSelectPopupBtn().addClickListener(this::handleMultiSelectPopup);
        this.view.getMultiSelectPopupBtn().setVisible(!isReadOnly);
        allItems.removeAll(referencedItems);
        this.itemListDataProvider = new ListDataProvider(allItems);
        referencedItems.forEach(this::addItemToView);
    }

    private void addItemToView(Item item) {
        ItemButtonComponent button = this.view.addItemComponent(item.getName(), this.isReadOnly);
        button.addClickListener((Button.ClickListener & Serializable)clickEvent -> this.itemDeSelected(item));
    }

    private void itemSelected(Item item) {
        LOGGER.trace("Item selected: {}", (Object)item);
        this.currentReferencedItems.add(item);
        this.profileReferenceChanged.accept(this.currentReferencedItems);
        this.addItemToView(item);
        this.addMemberDetails(item);
    }

    private void itemDeSelected(Item item) {
        LOGGER.trace("Item de-selected: {}", (Object)item);
        this.currentReferencedItems.remove(item);
        this.profileReferenceChanged.accept(this.currentReferencedItems);
        this.view.removeItemComponent(item.getName());
        this.view.removeReferenceSublineComponent(item.getName());
    }

    private void handleMultiSelectPopup(Button.ClickEvent event) {
        Window multiSelectPopup = new Window();
        multiSelectPopup.setModal(true);
        multiSelectPopup.setResizable(false);
        multiSelectPopup.setClosable(false);
        VerticalLayout main = new VerticalLayout();
        main.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_PLEASE_SELECT, new Object[0])));
        HorizontalLayout hl = new HorizontalLayout();
        ArrayList<Item> items = new ArrayList<Item>(this.itemListDataProvider.getItems());
        items.addAll(this.currentReferencedItems);
        ListDataProvider itemListDataProvider = new ListDataProvider(items);
        itemListDataProvider.setSortComparator(Comparator.comparing(Item::getName, String::compareToIgnoreCase)::compare);
        Grid referencesGrid = new Grid();
        referencesGrid.setDataProvider((DataProvider)itemListDataProvider);
        referencesGrid.setSelectionMode(Grid.SelectionMode.NONE);
        referencesGrid.removeHeaderRow(0);
        referencesGrid.addComponentColumn(this::createItemCheckBox);
        referencesGrid.setBodyRowHeight(40.0);
        main.addComponent((Component)referencesGrid);
        TextField filter = new TextField();
        filter.setPlaceholder(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_SEARCHFIELD_INPUTPROMT, new Object[0]));
        filter.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event1 -> itemListDataProvider.setFilter(Item::getName, (SerializablePredicate & Serializable)s -> s.toLowerCase().contains(((String)event1.getValue()).toLowerCase())));
        Button closeButton = new Button(this.mc.getMessage((Enum)ConsoleWebMessages.UI_BUTTON_CLOSE, new Object[0]));
        closeButton.addClickListener((Button.ClickListener & Serializable)e -> multiSelectPopup.close());
        HorizontalLayout bottomLine = new HorizontalLayout();
        bottomLine.addComponents(new Component[]{filter, closeButton});
        main.addComponent((Component)bottomLine);
        multiSelectPopup.setContent((Component)main);
        UI.getCurrent().addWindow(multiSelectPopup);
    }

    private CheckBox createItemCheckBox(Item item) {
        CheckBox checkBox = new CheckBox(item.getName(), this.currentReferencedItems.contains(item));
        checkBox.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            Boolean value = (Boolean)e.getValue();
            if (value.booleanValue()) {
                this.itemSelected(item);
            } else {
                this.itemDeSelected(item);
            }
        });
        return checkBox;
    }

    public void setProfileReferenceChangedConsumer(Consumer<List<Item>> consumer) {
        this.profileReferenceChanged = consumer;
    }

    public void showSublineContent(Function<Item, List<Item>> memberSupplier) {
        this.memberSupplier = memberSupplier;
        this.currentReferencedItems.forEach(this::addMemberDetails);
    }

    protected void addMemberDetails(Item item) {
        if (this.memberSupplier != null) {
            List<Item> members = this.memberSupplier.apply(item);
            List<ItemButtonComponent> components = members.stream().map(member -> new ItemButtonComponent(member.getName(), true)).collect(Collectors.toList());
            this.view.addReferenceSublineComponents(item.getName(), (Component[])components.toArray(new ItemButtonComponent[0]));
        }
    }
}

