/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.pkgmngr.ui.presenter;

import ch.qos.cal10n.MessageConveyor;
import com.vaadin.data.HasValue;
import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.CheckBox;
import com.vaadin.ui.Component;
import com.vaadin.ui.ComponentContainer;
import com.vaadin.ui.Label;
import com.vaadin.ui.UI;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.pkgmgr.PackageManager;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.op.PackageManagerOperation;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.progress.ListenableProgressFuture;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.pkgmngr.ui.InstallationPlanSummaryDialog;
import org.openthinclient.web.pkgmngr.ui.presenter.PackageDetailsUtil;
import org.openthinclient.web.pkgmngr.ui.view.AbstractPackageItem;
import org.openthinclient.web.progress.ProgressReceiverDialog;
import org.vaadin.viritin.button.MButton;

public class PackageDetailsPresenter {
    private final View view;
    private final PackageManager packageManager;
    private final MessageConveyor mc;
    private final ClientService clientService;

    public PackageDetailsPresenter(View view, PackageManager packageManager, ClientService clientService) {
        this.view = view;
        this.packageManager = packageManager;
        this.clientService = clientService;
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    public void setPackage(Package otcPackage) {
        if (otcPackage != null) {
            this.view.show();
            this.view.setName(otcPackage.getName());
            this.view.setVersion(otcPackage.getVersion().toStringWithoutEpoch());
            this.view.setDescription(otcPackage.getDescription());
            this.view.setShortDescription(otcPackage.getShortDescription());
            this.view.setSourceUrl(otcPackage.getSource().getUrl().toString());
            this.view.setChangeLog(otcPackage.getChangeLog());
            if (otcPackage.getLicense() != null) {
                this.view.setLicense(otcPackage.getLicense());
            }
            List<Package> installableAndExistingPackages = Stream.concat(this.packageManager.getInstalledPackages().stream(), this.packageManager.getInstallablePackages().stream()).sorted().collect(Collectors.toList());
            ArrayList<String> usedPackages = new ArrayList<String>();
            this.view.addDependencies(PackageDetailsUtil.getReferencedPackageItems(otcPackage.getDepends(), installableAndExistingPackages, usedPackages));
            if (otcPackage.getConflicts().isEmpty()) {
                this.view.hideConflictsTable();
            } else {
                this.view.addConflicts(PackageDetailsUtil.getReferencedPackageItems(otcPackage.getConflicts(), installableAndExistingPackages, usedPackages));
            }
            if (otcPackage.getProvides().isEmpty()) {
                this.view.hideProvidesTable();
            } else {
                this.view.addProvides(PackageDetailsUtil.getReferencedPackageItems(otcPackage.getProvides(), installableAndExistingPackages, usedPackages));
            }
            ComponentContainer actionBar = this.view.getActionBar();
            actionBar.removeAllComponents();
            if (this.packageManager.isInstallable(otcPackage)) {
                MButton installButton = ((MButton)new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_INSTALL_CAPTION, new Object[0])).withIcon((Resource)VaadinIcons.DOWNLOAD)).withListener((Button.ClickListener & Serializable)e -> this.doInstallPackage(otcPackage));
                installButton.addStyleName("package_detail_install_button");
                installButton.setEnabled(otcPackage.getLicense() == null);
                if (otcPackage.getLicense() != null) {
                    actionBar.addComponent((Component)new Label(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_CONFIRM_LICENCE_INFO, new Object[0])));
                }
                actionBar.addComponent((Component)installButton);
                this.view.getLicenseCheckbox().setVisible(otcPackage.getLicense() != null);
                this.view.getLicenseCheckbox().addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> installButton.setEnabled(((Boolean)e.getValue()).booleanValue()));
            }
            if (this.packageManager.isInstalled(otcPackage)) {
                actionBar.addComponent((Component)((MButton)new MButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_PACKAGEMANAGER_BUTTON_UNINSTALL_CAPTION, new Object[0])).withIcon((Resource)VaadinIcons.TRASH)).withListener((Button.ClickListener & Serializable)e -> this.doUninstallPackage(otcPackage)));
                this.view.getLicenseCheckbox().setVisible(false);
            }
        } else {
            this.view.hide();
        }
    }

    private void doUninstallPackage(Package otcPackage) {
        PackageManagerOperation op = this.packageManager.createOperation();
        op.uninstall(otcPackage);
        op.resolve();
        InstallationPlanSummaryDialog summaryDialog = new InstallationPlanSummaryDialog(op, this.packageManager);
        summaryDialog.onInstallClicked(() -> this.execute(op, false));
        summaryDialog.open(true);
    }

    private void execute(PackageManagerOperation op, boolean install) {
        ProgressReceiverDialog dialog = new ProgressReceiverDialog(install ? "Installation..." : "Uninstallation...");
        ListenableProgressFuture future = this.packageManager.execute(op);
        future.addCallback(this::onOperationSuccess, this::onOperationError);
        dialog.watch(future);
        this.view.hide();
        dialog.open(true);
    }

    private void onOperationError(Throwable throwable) {
    }

    private void onOperationSuccess(PackageManagerOperationReport packageManagerOperationReport) {
        this.clientService.reloadAllSchemas();
    }

    private void doInstallPackage(Package otcPackage) {
        PackageManagerOperation op = this.packageManager.createOperation();
        op.install(otcPackage);
        op.resolve();
        InstallationPlanSummaryDialog summaryDialog = new InstallationPlanSummaryDialog(op, this.packageManager);
        summaryDialog.onInstallClicked(() -> this.execute(op, true));
        summaryDialog.open(true);
    }

    public static interface View {
        public ComponentContainer getActionBar();

        public void setName(String var1);

        public void setVersion(String var1);

        public void setDescription(String var1);

        public void hide();

        public void show();

        public void setShortDescription(String var1);

        public void addDependencies(List<AbstractPackageItem> var1);

        public void addConflicts(List<AbstractPackageItem> var1);

        public void addProvides(List<AbstractPackageItem> var1);

        public void setSourceUrl(String var1);

        public void setChangeLog(String var1);

        public void setLicense(String var1);

        public void hideConflictsTable();

        public void hideProvidesTable();

        public CheckBox getLicenseCheckbox();
    }
}

