/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient;

import ch.qos.cal10n.IMessageConveyor;
import ch.qos.cal10n.MessageConveyor;
import com.vaadin.spring.annotation.SpringView;
import com.vaadin.ui.UI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import org.openthinclient.common.model.Client;
import org.openthinclient.common.model.ClientMetaData;
import org.openthinclient.common.model.DirectoryObject;
import org.openthinclient.common.model.Location;
import org.openthinclient.common.model.Printer;
import org.openthinclient.common.model.Profile;
import org.openthinclient.common.model.schema.Schema;
import org.openthinclient.common.model.schema.provider.SchemaProvider;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.LocationService;
import org.openthinclient.common.model.service.PrinterService;
import org.openthinclient.web.Audit;
import org.openthinclient.web.OTCSideBar;
import org.openthinclient.web.dashboard.DashboardNotificationService;
import org.openthinclient.web.i18n.ConsoleWebMessages;
import org.openthinclient.web.thinclient.AbstractThinclientView;
import org.openthinclient.web.thinclient.ProfilePanel;
import org.openthinclient.web.thinclient.ProfilePropertiesBuilder;
import org.openthinclient.web.thinclient.ProfileReferencesPanel;
import org.openthinclient.web.thinclient.exception.BuildProfileException;
import org.openthinclient.web.thinclient.model.DeleteMandate;
import org.openthinclient.web.thinclient.model.Item;
import org.openthinclient.web.thinclient.presenter.ProfilePanelPresenter;
import org.openthinclient.web.thinclient.presenter.ReferencePanelPresenter;
import org.openthinclient.web.thinclient.property.OtcPropertyGroup;
import org.openthinclient.web.ui.ManagerUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.vaadin.spring.events.EventBus;
import org.vaadin.spring.sidebar.annotation.SideBarItem;
import org.vaadin.spring.sidebar.annotation.ThemeIcon;

@SpringView(name="location_view", ui={ManagerUI.class})
@SideBarItem(sectionId="client-management", captionCode="UI_LOCATION_HEADER", order=80)
@ThemeIcon(value="icon/location.svg")
public final class LocationView
extends AbstractThinclientView {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocationView.class);
    public static final String NAME = "location_view";
    public static final String ICON = "icon/location.svg";
    public static final ConsoleWebMessages TITLE_KEY = ConsoleWebMessages.UI_LOCATION_HEADER;
    @Autowired
    private ClientService clientService;
    @Autowired
    private LocationService locationService;
    @Autowired
    private SchemaProvider schemaProvider;
    @Autowired
    private PrinterService printerService;
    @Autowired
    @Qualifier(value="deviceSideBar")
    OTCSideBar deviceSideBar;
    private final IMessageConveyor mc;
    private ProfilePropertiesBuilder builder = new ProfilePropertiesBuilder();

    public LocationView(EventBus.SessionEventBus eventBus, DashboardNotificationService notificationService) {
        super(ConsoleWebMessages.UI_LOCATION_HEADER, eventBus, notificationService);
        this.mc = new MessageConveyor(UI.getCurrent().getLocale());
    }

    @PostConstruct
    private void setup() {
        this.addStyleName(NAME);
        this.addCreateActionButton(this.mc.getMessage((Enum)ConsoleWebMessages.UI_THINCLIENT_ADD_LOCATION_LABEL, new Object[0]), ICON, "location_view/create");
    }

    @Override
    public Set getAllItems() {
        try {
            return this.locationService.findAll();
        }
        catch (Exception e) {
            LOGGER.warn("Cannot find directory-objects: " + e.getMessage());
            this.showError(e);
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Schema getSchema(String schemaName) {
        return this.schemaProvider.getSchema(Location.class, schemaName);
    }

    @Override
    public Map<String, String> getSchemaNames() {
        return Stream.of(this.schemaProvider.getSchemaNames(Location.class)).collect(Collectors.toMap(schemaName -> schemaName, schemaName -> this.getSchema((String)schemaName).getLabel()));
    }

    @Override
    public Client getClient(String name) {
        return (Client)this.clientService.findByName(name);
    }

    @Override
    public ProfilePanel createProfilePanel(DirectoryObject directoryObject) throws BuildProfileException {
        Profile profile = (Profile)directoryObject;
        List<OtcPropertyGroup> otcPropertyGroups = this.builder.getOtcPropertyGroups(this.getSchemaNames(), profile);
        OtcPropertyGroup meta = otcPropertyGroups.get(0);
        this.addProfileNameAlreadyExistsValidator(meta);
        ProfilePanel profilePanel = new ProfilePanel(profile.getName(), profile.getClass());
        ProfilePanelPresenter presenter = new ProfilePanelPresenter((AbstractThinclientView)this, profilePanel, profile);
        presenter.setDeleteMandate(this.createDeleteMandateFunction());
        presenter.setItemGroups(otcPropertyGroups);
        presenter.onValuesWritten(profilePanel1 -> this.saveValues(presenter, profile));
        return profilePanel;
    }

    @Override
    public ProfileReferencesPanel createReferencesPanel(DirectoryObject item) {
        ProfileReferencesPanel referencesPanel = new ProfileReferencesPanel(item.getClass());
        ReferencePanelPresenter refPresenter = new ReferencePanelPresenter(referencesPanel);
        Location location = (Location)item;
        Set clients = this.clientService.findByLocation(location.getName());
        refPresenter.showReference(clients, this.mc.getMessage((Enum)ConsoleWebMessages.UI_CLIENT_HEADER, new Object[0]) + " (readonly)", Collections.emptySet(), ClientMetaData.class, values -> this.saveReference((DirectoryObject)location, (List<Item>)values, Collections.emptySet(), ClientMetaData.class), null, true);
        Set all = this.printerService.findAll();
        refPresenter.showReference(location.getPrinters(), this.mc.getMessage((Enum)ConsoleWebMessages.UI_PRINTER_HEADER, new Object[0]), all, Printer.class, values -> this.saveReference((DirectoryObject)location, (List<Item>)values, all, Printer.class));
        return referencesPanel;
    }

    @Override
    protected Function<DirectoryObject, DeleteMandate> createDeleteMandateFunction() {
        return directoryObject -> {
            Location location = (Location)directoryObject;
            boolean optionalClient = this.clientService.findAll().stream().anyMatch(client -> client.getLocation() != null && client.getLocation().equals((Object)location));
            if (optionalClient) {
                return new DeleteMandate(false, this.mc.getMessage((Enum)ConsoleWebMessages.UI_COMMON_DELETE_LOCATION_DENIED, new Object[]{location.getName()}));
            }
            return new DeleteMandate(true, "");
        };
    }

    @Override
    public <T extends DirectoryObject> T getFreshProfile(String name) {
        return (T)this.locationService.findByName(name);
    }

    @Override
    public void save(DirectoryObject profile) {
        LOGGER.info("Save: " + profile);
        this.locationService.save((DirectoryObject)((Location)profile));
        Audit.logSave(profile);
    }

    @Override
    public void selectItem(DirectoryObject directoryObject) {
        LOGGER.info("sideBar: " + (Object)((Object)this.deviceSideBar));
        this.deviceSideBar.selectItem(NAME, directoryObject, this.getAllItems());
    }

    @Override
    public String getViewName() {
        return NAME;
    }

    @Override
    public ConsoleWebMessages getViewTitleKey() {
        return TITLE_KEY;
    }
}

