/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.web.thinclient.component;

import com.vaadin.icons.VaadinIcons;
import com.vaadin.server.Resource;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.CssLayout;
import com.vaadin.ui.Label;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.openthinclient.web.thinclient.component.ItemButtonComponent;
import org.openthinclient.web.thinclient.model.Item;

public class ReferencesComponent
extends CssLayout {
    private CssLayout referenceLine;
    private Button multiSelectPopupBtn;
    private NavigableMap<String, ItemButtonComponent> itemComponents = new TreeMap<String, ItemButtonComponent>(String.CASE_INSENSITIVE_ORDER);
    private Map<String, CssLayout> sublineComponents = new HashMap<String, CssLayout>();

    public ReferencesComponent(String labelText) {
        this.addStyleName("referenceComponent");
        this.multiSelectPopupBtn = new Button();
        this.multiSelectPopupBtn.addStyleName("multiSelectPopupButton");
        this.multiSelectPopupBtn.setIcon((Resource)VaadinIcons.PLUS_CIRCLE_O);
        this.multiSelectPopupBtn.addStyleName("borderless");
        CssLayout hl = new CssLayout();
        hl.addStyleName("referenceComponentCaption");
        Label label = new Label(labelText);
        label.addStyleName("referenceLabel");
        hl.addComponents(new Component[]{label, this.multiSelectPopupBtn});
        this.addComponent((Component)hl);
        this.referenceLine = new CssLayout();
        this.referenceLine.addStyleName("referenceLine");
        this.addComponent((Component)this.referenceLine);
    }

    public ItemButtonComponent addItemComponent(Item item, boolean isReadOnly) {
        ItemButtonComponent buttonComponent = new ItemButtonComponent(item, isReadOnly);
        this.itemComponents.put(item.getName(), buttonComponent);
        this.addComponentSorted(item.getName(), (Component)buttonComponent);
        return buttonComponent;
    }

    public void removeItemComponent(String name) {
        if (this.itemComponents.containsKey(name)) {
            this.referenceLine.removeComponent((Component)this.itemComponents.remove(name));
        }
    }

    public Button getMultiSelectPopupBtn() {
        return this.multiSelectPopupBtn;
    }

    public void addReferenceSublineComponents(String name, Component ... components) {
        this.addStyleName("has-subline-content");
        CssLayout referenceContentLine = new CssLayout();
        referenceContentLine.addComponents(components);
        referenceContentLine.setStyleName("referenceLine");
        referenceContentLine.addStyleName("subline-content");
        this.sublineComponents.put(name, referenceContentLine);
        this.addComponentSorted(name, (Component)referenceContentLine);
    }

    public void removeReferenceSublineComponent(String name) {
        if (this.sublineComponents.containsKey(name)) {
            this.referenceLine.removeComponent((Component)this.sublineComponents.remove(name));
        }
    }

    private void addComponentSorted(String name, Component component) {
        Map.Entry<String, ItemButtonComponent> nextItemEntry = this.itemComponents.higherEntry(name);
        if (nextItemEntry != null) {
            this.referenceLine.addComponent(component, this.referenceLine.getComponentIndex((Component)nextItemEntry.getValue()));
        } else {
            this.referenceLine.addComponent(component);
        }
    }
}

