/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.jnlp.jardiff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import org.openthinclient.jnlp.jardiff.JarDiffConstants;
import org.openthinclient.jnlp.jardiff.JarDiffPatcher;

public class JarDiff
implements JarDiffConstants {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static byte[] newBytes = new byte[2048];
    private static byte[] oldBytes = new byte[2048];
    private static ResourceBundle _resources = null;
    private static boolean _debug;

    public static ResourceBundle getResources() {
        if (_resources == null) {
            _resources = ResourceBundle.getBundle("org/openthinclient/jnlp/jardiff/resources/strings");
        }
        return _resources;
    }

    public static void createPatch(String oldPath, String newPath, OutputStream os, boolean minimal) throws IOException {
        JarFile2 oldJar = new JarFile2(oldPath);
        JarFile2 newJar = new JarFile2(newPath);
        try {
            String oldName;
            HashMap<String, String> moved = new HashMap<String, String>();
            HashSet visited = new HashSet();
            HashSet<String> implicit = new HashSet<String>();
            HashSet<String> moveSrc = new HashSet<String>();
            HashSet<String> newEntries = new HashSet<String>();
            Iterator<Object> entries = newJar.getJarEntries();
            if (entries != null) {
                while (entries.hasNext()) {
                    JarEntry newEntry = (JarEntry)entries.next();
                    String newname = newEntry.getName();
                    String oldname = oldJar.getBestMatch(newJar, newEntry);
                    if (oldname == null) {
                        if (_debug) {
                            System.out.println("NEW: " + newname);
                        }
                        newEntries.add(newname);
                        continue;
                    }
                    if (oldname.equals(newname) && !moveSrc.contains(oldname)) {
                        if (_debug) {
                            System.out.println(newname + " added to implicit set!");
                        }
                        implicit.add(newname);
                        continue;
                    }
                    if (!minimal && (implicit.contains(oldname) || moveSrc.contains(oldname))) {
                        if (_debug) {
                            System.out.println("NEW: " + newname);
                        }
                        newEntries.add(newname);
                    } else {
                        if (_debug) {
                            System.err.println("moved.put " + newname + " " + oldname);
                        }
                        moved.put(newname, oldname);
                        moveSrc.add(oldname);
                    }
                    if (!implicit.contains(oldname) || !minimal) continue;
                    if (_debug) {
                        System.err.println("implicit.remove " + oldname);
                        System.err.println("moved.put " + oldname + " " + oldname);
                    }
                    implicit.remove(oldname);
                    moved.put(oldname, oldname);
                    moveSrc.add(oldname);
                }
            }
            ArrayList<String> deleted = new ArrayList<String>();
            entries = oldJar.getJarEntries();
            if (entries != null) {
                while (entries.hasNext()) {
                    JarEntry oldEntry = (JarEntry)entries.next();
                    oldName = oldEntry.getName();
                    if (implicit.contains(oldName) || moveSrc.contains(oldName) || newEntries.contains(oldName)) continue;
                    if (_debug) {
                        System.err.println("deleted.add " + oldName);
                    }
                    deleted.add(oldName);
                }
            }
            if (_debug) {
                String newName;
                entries = moved.keySet().iterator();
                if (entries != null) {
                    System.out.println("MOVED MAP!!!");
                    while (entries.hasNext()) {
                        newName = (String)entries.next();
                        oldName = (String)moved.get(newName);
                        System.out.println("key is " + newName + " value is " + oldName);
                    }
                }
                if ((entries = implicit.iterator()) != null) {
                    System.out.println("IMOVE MAP!!!");
                    while (entries.hasNext()) {
                        newName = (String)entries.next();
                        System.out.println("key is " + newName);
                    }
                }
            }
            JarOutputStream jos = new JarOutputStream(os);
            JarDiff.createIndex(jos, deleted, moved);
            entries = newEntries.iterator();
            if (entries != null) {
                while (entries.hasNext()) {
                    String newName = (String)entries.next();
                    if (_debug) {
                        System.out.println("New File: " + newName);
                    }
                    JarDiff.writeEntry(jos, newJar.getEntryByName(newName), newJar);
                }
            }
            jos.finish();
            jos.close();
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                oldJar.getJarFile().close();
            }
            catch (IOException iOException) {}
            try {
                newJar.getJarFile().close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void createIndex(JarOutputStream jos, List oldEntries, Map movedMap) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("version 1.0");
        writer.write("\r\n");
        for (int counter = 0; counter < oldEntries.size(); ++counter) {
            String name = (String)oldEntries.get(counter);
            writer.write("remove");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, name);
            writer.write("\r\n");
        }
        Iterator names = movedMap.keySet().iterator();
        if (names != null) {
            while (names.hasNext()) {
                String newName = (String)names.next();
                String oldName = (String)movedMap.get(newName);
                writer.write("move");
                writer.write(" ");
                JarDiff.writeEscapedString(writer, oldName);
                writer.write(" ");
                JarDiff.writeEscapedString(writer, newName);
                writer.write("\r\n");
            }
        }
        JarEntry je = new JarEntry("META-INF/INDEX.JD");
        byte[] bytes = writer.toString().getBytes("UTF-8");
        writer.close();
        jos.putNextEntry(je);
        jos.write(bytes, 0, bytes.length);
    }

    private static void writeEscapedString(Writer writer, String string) throws IOException {
        int index = 0;
        int last = 0;
        char[] chars = null;
        while ((index = string.indexOf(32, index)) != -1) {
            if (last != index) {
                if (chars == null) {
                    chars = string.toCharArray();
                }
                writer.write(chars, last, index - last);
            }
            last = index++;
            writer.write(92);
        }
        if (last != 0) {
            writer.write(chars, last, chars.length - last);
        } else {
            writer.write(string);
        }
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, JarFile2 file) throws IOException {
        JarDiff.writeEntry(jos, entry, file.getJarFile().getInputStream(entry));
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(entry);
        try {
            int size = data.read(newBytes);
            while (size != -1) {
                jos.write(newBytes, 0, size);
                size = data.read(newBytes);
            }
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void showHelp() {
        System.out.println("JarDiff: [-nonminimal (for backward compatibility with 1.0.1/1.0] [-creatediff | -applydiff] [-output file] old.jar new.jar");
    }

    public static void main(String[] args) throws IOException {
        boolean diff = true;
        boolean minimal = true;
        String outputFile = "out.jardiff";
        for (int counter = 0; counter < args.length; ++counter) {
            FileOutputStream os;
            if (args[counter].equals("-nonminimal") || args[counter].equals("-n")) {
                minimal = false;
                continue;
            }
            if (args[counter].equals("-creatediff") || args[counter].equals("-c")) {
                diff = true;
                continue;
            }
            if (args[counter].equals("-applydiff") || args[counter].equals("-a")) {
                diff = false;
                continue;
            }
            if (args[counter].equals("-debug") || args[counter].equals("-d")) {
                _debug = true;
                continue;
            }
            if (args[counter].equals("-output") || args[counter].equals("-o")) {
                if (++counter >= args.length) continue;
                outputFile = args[counter];
                continue;
            }
            if (args[counter].equals("-applydiff") || args[counter].equals("-a")) {
                diff = false;
                continue;
            }
            if (counter + 2 != args.length) {
                JarDiff.showHelp();
                System.exit(0);
            }
            if (diff) {
                try {
                    os = new FileOutputStream(outputFile);
                    JarDiff.createPatch(args[counter], args[counter + 1], os, minimal);
                    ((OutputStream)os).close();
                }
                catch (IOException ioe) {
                    try {
                        System.out.println(JarDiff.getResources().getString("jardiff.error.create") + " " + ioe);
                    }
                    catch (MissingResourceException missingResourceException) {}
                }
            } else {
                try {
                    os = new FileOutputStream(outputFile);
                    new JarDiffPatcher().applyPatch(null, args[counter], args[counter + 1], os);
                    ((OutputStream)os).close();
                }
                catch (IOException ioe) {
                    try {
                        System.out.println(JarDiff.getResources().getString("jardiff.error.apply") + " " + ioe);
                    }
                    catch (MissingResourceException missingResourceException) {
                        // empty catch block
                    }
                }
            }
            System.exit(0);
        }
        JarDiff.showHelp();
    }

    private static class JarFile2 {
        private JarFile _jar;
        private List _entries;
        private HashMap _nameToEntryMap;
        private HashMap _crcToEntryMap;

        public JarFile2(String path) throws IOException {
            this._jar = new JarFile(new File(path));
            this.index();
        }

        public JarFile getJarFile() {
            return this._jar;
        }

        public Iterator getJarEntries() {
            return this._entries.iterator();
        }

        public JarEntry getEntryByName(String name) {
            return (JarEntry)this._nameToEntryMap.get(name);
        }

        private static boolean differs(InputStream oldIS, InputStream newIS) throws IOException {
            int newSize = 0;
            int total = 0;
            boolean retVal = false;
            try {
                block13: while (newSize != -1) {
                    int oldSize;
                    newSize = newIS.read(newBytes);
                    if (newSize != (oldSize = oldIS.read(oldBytes))) {
                        if (_debug) {
                            System.out.println("\tread sizes differ: " + newSize + " " + oldSize + " total " + total);
                        }
                        retVal = true;
                        break;
                    }
                    if (newSize <= 0) continue;
                    while (--newSize >= 0) {
                        ++total;
                        if (newBytes[newSize] != oldBytes[newSize]) {
                            if (_debug) {
                                System.out.println("\tbytes differ at " + total);
                            }
                            retVal = true;
                            continue block13;
                        }
                        if (retVal) continue block13;
                        newSize = 0;
                    }
                }
            }
            catch (IOException ioE) {
                throw ioE;
            }
            finally {
                try {
                    oldIS.close();
                }
                catch (IOException iOException) {}
                try {
                    newIS.close();
                }
                catch (IOException iOException) {}
            }
            return retVal;
        }

        public String getBestMatch(JarFile2 file, JarEntry entry) throws IOException {
            if (this.contains(file, entry)) {
                return entry.getName();
            }
            return this.hasSameContent(file, entry);
        }

        public boolean contains(JarFile2 f, JarEntry e) throws IOException {
            InputStream newIS;
            JarEntry thisEntry = this.getEntryByName(e.getName());
            if (thisEntry == null) {
                return false;
            }
            if (thisEntry.getCrc() != e.getCrc()) {
                return false;
            }
            InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
            boolean retValue = JarFile2.differs(oldIS, newIS = f.getJarFile().getInputStream(e));
            return !retValue;
        }

        public String hasSameContent(JarFile2 file, JarEntry entry) throws IOException {
            LinkedList ll;
            ListIterator li;
            String thisName = null;
            Long crcL = new Long(entry.getCrc());
            if (this._crcToEntryMap.containsKey(crcL) && (li = (ll = (LinkedList)this._crcToEntryMap.get(crcL)).listIterator(0)) != null) {
                while (li.hasNext()) {
                    InputStream newIS;
                    JarEntry thisEntry = (JarEntry)li.next();
                    InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
                    if (JarFile2.differs(oldIS, newIS = file.getJarFile().getInputStream(entry))) continue;
                    thisName = thisEntry.getName();
                    return thisName;
                }
            }
            return thisName;
        }

        private void index() throws IOException {
            Enumeration<JarEntry> entries = this._jar.entries();
            this._nameToEntryMap = new HashMap();
            this._crcToEntryMap = new HashMap();
            this._entries = new ArrayList();
            if (_debug) {
                System.out.println("indexing: " + this._jar.getName());
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    LinkedList ll;
                    JarEntry entry = entries.nextElement();
                    long crc = entry.getCrc();
                    Long crcL = new Long(crc);
                    if (_debug) {
                        System.out.println("\t" + entry.getName() + " CRC " + crc);
                    }
                    this._nameToEntryMap.put(entry.getName(), entry);
                    this._entries.add(entry);
                    if (this._crcToEntryMap.containsKey(crcL)) {
                        ll = (LinkedList)this._crcToEntryMap.get(crcL);
                        ll.add(entry);
                        this._crcToEntryMap.put(crcL, ll);
                        continue;
                    }
                    ll = new LinkedList();
                    ll.add(entry);
                    this._crcToEntryMap.put(crcL, ll);
                }
            }
        }
    }
}

