/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.jnlp.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpUtils;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.input.StAXEventBuilder;
import org.jdom2.output.XMLOutputter;
import org.openthinclient.jnlp.servlet.DownloadRequest;
import org.openthinclient.jnlp.servlet.DownloadResponse;
import org.openthinclient.jnlp.servlet.JnlpResource;
import org.openthinclient.jnlp.servlet.Logger;

public class JnlpFileHandler {
    private static final String JNLP_MIME_TYPE = "application/x-java-jnlp-file";
    private static final String HEADER_LASTMOD = "Last-Modified";
    private ServletContext _servletContext;
    private Logger _log = null;
    private HashMap _jnlpFiles = null;

    public JnlpFileHandler(ServletContext servletContext, Logger log) {
        this._servletContext = servletContext;
        this._log = log;
        this._jnlpFiles = new HashMap();
    }

    public synchronized DownloadResponse getJnlpFile(JnlpResource jnlpres, DownloadRequest dreq) throws IOException {
        int read;
        String reqUrl;
        JnlpFileEntry jnlpFile;
        String path = jnlpres.getPath();
        URL resource = jnlpres.getResource();
        long lastModified = jnlpres.getLastModified();
        this._log.addDebug("lastModified: " + lastModified + " " + new Date(lastModified));
        if (lastModified == 0L) {
            this._log.addWarning("servlet.log.warning.nolastmodified", path);
        }
        if ((jnlpFile = (JnlpFileEntry)this._jnlpFiles.get(reqUrl = HttpUtils.getRequestURL((HttpServletRequest)dreq.getHttpRequest()).toString())) != null && jnlpFile.getLastModified() == lastModified) {
            return jnlpFile.getResponse();
        }
        long timeStamp = lastModified;
        String mimeType = this._servletContext.getMimeType(path);
        if (mimeType == null) {
            mimeType = JNLP_MIME_TYPE;
        }
        StringBuilder jnlpFileTemplate = new StringBuilder();
        URLConnection conn = resource.openConnection();
        InputStream is = conn.getInputStream();
        InputStreamReader reader = new InputStreamReader(is);
        char[] chars = new char[1024];
        while ((read = reader.read(chars)) != -1) {
            jnlpFileTemplate.append(chars, 0, read);
        }
        try {
            is.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String jnlpFileContent = this.specializeJnlpTemplate(dreq.getHttpRequest(), path, jnlpFileTemplate.toString());
        byte[] byteContent = jnlpFileContent.getBytes("UTF-8");
        DownloadResponse resp = DownloadResponse.getFileDownloadResponse(byteContent, mimeType, timeStamp, jnlpres.getReturnVersionId());
        jnlpFile = new JnlpFileEntry(resp, lastModified);
        this._jnlpFiles.put(reqUrl, jnlpFile);
        return resp;
    }

    public synchronized DownloadResponse getJnlpFileEx(JnlpResource jnlpres, DownloadRequest dreq) throws IOException {
        JnlpFileEntry jnlpFile;
        String path = jnlpres.getPath();
        URL resource = jnlpres.getResource();
        long lastModified = jnlpres.getLastModified();
        this._log.addDebug("lastModified: " + lastModified + " " + new Date(lastModified));
        if (lastModified == 0L) {
            this._log.addWarning("servlet.log.warning.nolastmodified", path);
        }
        String reqUrl = HttpUtils.getRequestURL((HttpServletRequest)dreq.getHttpRequest()).toString();
        if (dreq.getQuery() != null) {
            reqUrl = reqUrl + dreq.getQuery();
        }
        if ((jnlpFile = (JnlpFileEntry)this._jnlpFiles.get(reqUrl)) != null && jnlpFile.getLastModified() == lastModified) {
            return jnlpFile.getResponse();
        }
        long timeStamp = lastModified;
        String mimeType = this._servletContext.getMimeType(path);
        if (mimeType == null) {
            mimeType = JNLP_MIME_TYPE;
        }
        StringBuffer jnlpFileTemplate = new StringBuffer();
        URLConnection conn = resource.openConnection();
        BufferedReader br = new BufferedReader(new InputStreamReader(conn.getInputStream(), "UTF-8"));
        String line = br.readLine();
        if (line != null && line.startsWith("TS:")) {
            timeStamp = this.parseTimeStamp(line.substring(3));
            this._log.addDebug("Timestamp: " + timeStamp + " " + new Date(timeStamp));
            if (timeStamp == 0L) {
                this._log.addWarning("servlet.log.warning.notimestamp", path);
                timeStamp = lastModified;
            }
            line = br.readLine();
        }
        while (line != null) {
            jnlpFileTemplate.append(line);
            line = br.readLine();
        }
        String jnlpFileContent = this.specializeJnlpTemplate(dreq.getHttpRequest(), path, jnlpFileTemplate.toString());
        String query = dreq.getQuery();
        String testJRE = dreq.getTestJRE();
        this._log.addDebug("Double check query string: " + query);
        if (query != null && query.trim().length() > 0) {
            byte[] cb = jnlpFileContent.getBytes("UTF-8");
            try {
                String ver;
                Element j2se;
                XMLInputFactory factory = XMLInputFactory.newFactory();
                XMLEventReader reader = factory.createXMLEventReader(new ByteArrayInputStream(cb));
                StAXEventBuilder builder = new StAXEventBuilder();
                Document document = builder.build(reader);
                boolean modified = false;
                Element root = document.getRootElement();
                if (root.getAttribute("href") != null) {
                    String href = root.getAttribute("href").getValue();
                    root.setAttribute("href", href + "?" + query);
                    modified = true;
                }
                if (testJRE != null && (j2se = root.getChild("j2se")) != null && (ver = j2se.getAttribute("version").getValue()).length() > 0) {
                    j2se.setAttribute("version", testJRE);
                    modified = true;
                }
                if (modified) {
                    XMLOutputter outputter = new XMLOutputter();
                    StringWriter sw = new StringWriter();
                    outputter.output(document, (Writer)sw);
                    jnlpFileContent = sw.toString();
                }
                this._log.addDebug("Converted jnlpFileContent: " + jnlpFileContent);
                if (modified) {
                    timeStamp = new Date().getTime();
                    this._log.addDebug("Last modified on the fly:  " + timeStamp);
                }
            }
            catch (Exception e) {
                this._log.addDebug(e.toString(), e);
            }
        }
        byte[] byteContent = jnlpFileContent.getBytes("UTF-8");
        DownloadResponse resp = DownloadResponse.getFileDownloadResponse(byteContent, mimeType, timeStamp, jnlpres.getReturnVersionId());
        jnlpFile = new JnlpFileEntry(resp, lastModified);
        this._jnlpFiles.put(reqUrl, jnlpFile);
        return resp;
    }

    private String specializeJnlpTemplate(HttpServletRequest request, String respath, String jnlpTemplate) {
        String urlprefix = this.getUrlPrefix(request);
        int idx = respath.lastIndexOf(47);
        String name = respath.substring(idx + 1);
        String codebase = respath.substring(0, idx + 1);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$name", name);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$hostname", request.getServerName());
        jnlpTemplate = this.substitute(jnlpTemplate, "$$codebase", urlprefix + request.getContextPath() + codebase);
        jnlpTemplate = this.substitute(jnlpTemplate, "$$context", urlprefix + request.getContextPath());
        jnlpTemplate = this.substitute(jnlpTemplate, "$$site", urlprefix);
        return jnlpTemplate;
    }

    private String getUrlPrefix(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url.toString();
    }

    private String substitute(String target, String key, String value) {
        int start = 0;
        int idx;
        while ((idx = target.indexOf(key, start)) != -1) {
            target = target.substring(0, idx) + value + target.substring(idx + key.length());
            start = idx + value.length();
        }
        return target;
    }

    private long parseTimeStamp(String timestamp) {
        int ss;
        int mm;
        int hh;
        int DD;
        int MM;
        int YYYY;
        block10: {
            YYYY = 0;
            MM = 0;
            DD = 0;
            hh = 0;
            mm = 0;
            ss = 0;
            timestamp = timestamp.trim();
            try {
                if (this.matchPattern("####-##-## ##:##", timestamp)) {
                    YYYY = this.getIntValue(timestamp, 0, 4);
                    MM = this.getIntValue(timestamp, 5, 7);
                    DD = this.getIntValue(timestamp, 8, 10);
                    hh = this.getIntValue(timestamp, 11, 13);
                    mm = this.getIntValue(timestamp, 14, 16);
                    if (this.matchPattern(":##", timestamp = timestamp.substring(16))) {
                        ss = this.getIntValue(timestamp, 1, 3);
                        timestamp = timestamp.substring(3);
                    }
                    break block10;
                }
                if (this.matchPattern("############", timestamp)) {
                    YYYY = this.getIntValue(timestamp, 0, 4);
                    MM = this.getIntValue(timestamp, 4, 6);
                    DD = this.getIntValue(timestamp, 6, 8);
                    hh = this.getIntValue(timestamp, 8, 10);
                    mm = this.getIntValue(timestamp, 10, 12);
                    if (this.matchPattern("##", timestamp = timestamp.substring(12))) {
                        ss = this.getIntValue(timestamp, 0, 2);
                        timestamp = timestamp.substring(2);
                    }
                    break block10;
                }
                return 0L;
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        String timezone = null;
        timestamp = timestamp.trim();
        if (timestamp.equalsIgnoreCase("Z")) {
            timezone = "GMT";
        } else if (timestamp.startsWith("+") || timestamp.startsWith("-")) {
            timezone = "GMT" + timestamp;
        }
        if (timezone == null) {
            Calendar cal = Calendar.getInstance();
            cal.set(YYYY, MM - 1, DD, hh, mm, ss);
            return cal.getTime().getTime();
        }
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone(timezone));
        cal.set(YYYY, MM - 1, DD, hh, mm, ss);
        return cal.getTime().getTime();
    }

    private int getIntValue(String key, int start, int end) {
        return Integer.parseInt(key.substring(start, end));
    }

    private boolean matchPattern(String pattern, String key) {
        if (key.length() < pattern.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length(); ++i) {
            char format = pattern.charAt(i);
            char ch = key.charAt(i);
            if (format == '#' && Character.isDigit(ch) || format == ch) continue;
            return false;
        }
        return true;
    }

    private static class JnlpFileEntry {
        DownloadResponse _response;
        private long _lastModified;

        JnlpFileEntry(DownloadResponse response, long lastmodfied) {
            this._response = response;
            this._lastModified = lastmodfied;
        }

        public DownloadResponse getResponse() {
            return this._response;
        }

        long getLastModified() {
            return this._lastModified;
        }
    }
}

