/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.jnlp.servlet;

import java.util.ArrayList;
import org.openthinclient.jnlp.servlet.XMLAttribute;
import org.openthinclient.jnlp.servlet.XMLNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class XMLParsing {
    public static XMLNode convert(Node n) {
        if (n == null) {
            return null;
        }
        if (n instanceof Text) {
            Text tn = (Text)n;
            return new XMLNode(tn.getNodeValue());
        }
        if (n instanceof Element) {
            Element en = (Element)n;
            XMLAttribute xmlatts = null;
            NamedNodeMap attributes = en.getAttributes();
            for (int i = attributes.getLength() - 1; i >= 0; --i) {
                Attr ar = (Attr)attributes.item(i);
                xmlatts = new XMLAttribute(ar.getName(), ar.getValue(), xmlatts);
            }
            XMLNode thisNode = new XMLNode(en.getNodeName(), xmlatts, null, null);
            XMLNode last = null;
            for (Node nn = en.getFirstChild(); nn != null; nn = nn.getNextSibling()) {
                if (thisNode.getNested() == null) {
                    last = XMLParsing.convert(nn);
                    thisNode.setNested(last);
                } else {
                    XMLNode nnode = XMLParsing.convert(nn);
                    last.setNext(nnode);
                    last = nnode;
                }
                last.setParent(thisNode);
            }
            return thisNode;
        }
        return null;
    }

    public static boolean isElementPath(XMLNode root, String path) {
        return XMLParsing.findElementPath(root, path) != null;
    }

    public static String getPathString(XMLNode e) {
        return e == null || !e.isElement() ? "" : XMLParsing.getPathString(e.getParent()) + "<" + e.getName() + ">";
    }

    public static String getElementContent(XMLNode root, String path) {
        return XMLParsing.getElementContent(root, path, null);
    }

    public static String[] getMultiElementContent(XMLNode root, String path) {
        final ArrayList list = new ArrayList();
        XMLParsing.visitElements(root, path, new ElementVisitor(){

            @Override
            public void visitElement(XMLNode n) {
                String value = XMLParsing.getElementContent(n, "");
                if (value != null) {
                    list.add(value);
                }
            }
        });
        if (list.size() == 0) {
            return null;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String getElementContent(XMLNode root, String path, String defaultvalue) {
        XMLNode e = XMLParsing.findElementPath(root, path);
        if (e == null) {
            return defaultvalue;
        }
        XMLNode n = e.getNested();
        if (n != null && !n.isElement()) {
            return n.getName();
        }
        return defaultvalue;
    }

    public static XMLNode findElementPath(XMLNode elem, String path) {
        if (elem == null) {
            return null;
        }
        if (path == null || path.length() == 0) {
            return elem;
        }
        int idx = path.indexOf(62);
        String head = path.substring(1, idx);
        String tail = path.substring(idx + 1);
        return XMLParsing.findElementPath(XMLParsing.findChildElement(elem, head), tail);
    }

    public static XMLNode findChildElement(XMLNode elem, String tag) {
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement() || !n.getName().equals(tag)) continue;
            return n;
        }
        return null;
    }

    public static void visitElements(XMLNode root, String path, ElementVisitor ev) {
        int idx = path.lastIndexOf(60);
        String head = path.substring(0, idx);
        String tag = path.substring(idx + 1, path.length() - 1);
        XMLNode elem = XMLParsing.findElementPath(root, head);
        if (elem == null) {
            return;
        }
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement() || !n.getName().equals(tag)) continue;
            ev.visitElement(n);
        }
    }

    public static void visitChildrenElements(XMLNode elem, ElementVisitor ev) {
        for (XMLNode n = elem.getNested(); n != null; n = n.getNext()) {
            if (!n.isElement()) continue;
            ev.visitElement(n);
        }
    }

    public static abstract class ElementVisitor {
        public abstract void visitElement(XMLNode var1);
    }
}

