/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.jnlp.util;

import java.util.ArrayList;
import java.util.Arrays;

public class VersionID
implements Comparable {
    private String[] _tuple;
    private boolean _usePrefixMatch = false;
    private boolean _useGreaterThan = false;
    private boolean _isCompound = false;
    private VersionID _rest;

    public VersionID(String str) {
        if (str == null && str.length() == 0) {
            this._tuple = new String[0];
            return;
        }
        int amp = str.indexOf("&");
        if (amp >= 0) {
            this._isCompound = true;
            VersionID firstPart = new VersionID(str.substring(0, amp));
            this._rest = new VersionID(str.substring(amp + 1));
            this._tuple = firstPart._tuple;
            this._usePrefixMatch = firstPart._usePrefixMatch;
            this._useGreaterThan = firstPart._useGreaterThan;
        } else {
            if (str.endsWith("+")) {
                this._useGreaterThan = true;
                str = str.substring(0, str.length() - 1);
            } else if (str.endsWith("*")) {
                this._usePrefixMatch = true;
                str = str.substring(0, str.length() - 1);
            }
            ArrayList<String> list = new ArrayList<String>();
            int start = 0;
            for (int i = 0; i < str.length(); ++i) {
                if (".-_".indexOf(str.charAt(i)) == -1) continue;
                if (start < i) {
                    String value = str.substring(start, i);
                    list.add(value);
                }
                start = i + 1;
            }
            if (start < str.length()) {
                list.add(str.substring(start, str.length()));
            }
            this._tuple = new String[list.size()];
            this._tuple = list.toArray(this._tuple);
        }
    }

    public boolean isSimpleVersion() {
        return !this._useGreaterThan && !this._usePrefixMatch && !this._isCompound;
    }

    public boolean match(VersionID vid) {
        if (this._isCompound && !this._rest.match(vid)) {
            return false;
        }
        return this._usePrefixMatch ? this.isPrefixMatch(vid) : (this._useGreaterThan ? vid.isGreaterThanOrEqual(this) : this.matchTuple(vid));
    }

    public boolean equals(Object o) {
        if (this.matchTuple(o)) {
            VersionID ov = (VersionID)o;
            if ((this._rest == null || this._rest.equals(ov._rest)) && this._useGreaterThan == ov._useGreaterThan && this._usePrefixMatch == ov._usePrefixMatch) {
                return true;
            }
        }
        return false;
    }

    private boolean matchTuple(Object o) {
        if (o == null || !(o instanceof VersionID)) {
            return false;
        }
        VersionID vid = (VersionID)o;
        String[] t1 = this.normalize(this._tuple, vid._tuple.length);
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < t1.length; ++i) {
            Object o2;
            Object o1 = this.getValueAsObject(t1[i]);
            if (o1.equals(o2 = this.getValueAsObject(t2[i]))) continue;
            return false;
        }
        return true;
    }

    private Object getValueAsObject(String value) {
        if (value.length() > 0 && value.charAt(0) != '-') {
            try {
                return Integer.valueOf(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return value;
    }

    public boolean isGreaterThan(VersionID vid) {
        return this.isGreaterThanOrEqualHelper(vid, false);
    }

    public boolean isGreaterThanOrEqual(VersionID vid) {
        return this.isGreaterThanOrEqualHelper(vid, true);
    }

    private boolean isGreaterThanOrEqualHelper(VersionID vid, boolean allowEqual) {
        if (this._isCompound && !this._rest.isGreaterThanOrEqualHelper(vid, allowEqual)) {
            return false;
        }
        String[] t1 = this.normalize(this._tuple, vid._tuple.length);
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < t1.length; ++i) {
            String s2;
            Object e2;
            Object e1 = this.getValueAsObject(t1[i]);
            if (e1.equals(e2 = this.getValueAsObject(t2[i]))) continue;
            if (e1 instanceof Integer && e2 instanceof Integer) {
                return (Integer)e1 > (Integer)e2;
            }
            String s1 = t1[i].toString();
            return s1.compareTo(s2 = t2[i].toString()) > 0;
        }
        return allowEqual;
    }

    public boolean isPrefixMatch(VersionID vid) {
        if (this._isCompound && !this._rest.isPrefixMatch(vid)) {
            return false;
        }
        String[] t2 = this.normalize(vid._tuple, this._tuple.length);
        for (int i = 0; i < this._tuple.length; ++i) {
            String e1 = this._tuple[i];
            String e2 = t2[i];
            if (e1.equals(e2)) continue;
            return false;
        }
        return true;
    }

    private String[] normalize(String[] list, int minlength) {
        if (list.length < minlength) {
            Object[] newlist = new String[minlength];
            System.arraycopy(list, 0, newlist, 0, list.length);
            Arrays.fill(newlist, list.length, newlist.length, "0");
            return newlist;
        }
        return list;
    }

    public int compareTo(Object o) {
        if (o == null || !(o instanceof VersionID)) {
            return -1;
        }
        VersionID vid = (VersionID)o;
        return this.equals(vid) ? 0 : (this.isGreaterThanOrEqual(vid) ? 1 : -1);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this._tuple.length - 1; ++i) {
            sb.append(this._tuple[i]);
            sb.append('.');
        }
        if (this._tuple.length > 0) {
            sb.append(this._tuple[this._tuple.length - 1]);
        }
        if (this._usePrefixMatch) {
            sb.append('+');
        }
        return sb.toString();
    }
}

