/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.control.cmd;

import java.nio.file.Path;
import org.kohsuke.args4j.Option;
import org.openthinclient.runtime.control.cmd.AbstractCommand;
import org.openthinclient.service.common.home.ManagerHome;
import org.openthinclient.service.common.home.impl.ManagerHomeFactory;

public class RemoveServerIdCommand
extends AbstractCommand<Options> {
    public RemoveServerIdCommand() {
        super("rm-server-id");
    }

    @Override
    public Options createOptionsObject() {
        return new Options();
    }

    @Override
    public void execute(Options options) throws Exception {
        ManagerHomeFactory managerHomeFactory = new ManagerHomeFactory();
        managerHomeFactory.setManagerHomeDirectory(options.homePath.toFile());
        if (!managerHomeFactory.isManagerHomeValidAndInstalled()) {
            System.err.println("Not a valid manager home directory: " + options.homePath.toAbsolutePath());
            System.exit(1);
            return;
        }
        ManagerHome managerHome = managerHomeFactory.create();
        managerHome.getMetadata().setServerID(null);
        managerHome.getMetadata().save();
    }

    public class Options {
        @Option(name="--home", required=true, metaVar="DIR", usage="The target manager home directory")
        public Path homePath;
    }
}

