/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.adapter;

import com.jgoodies.binding.list.SelectionInList;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ComboBoxAdapter
extends AbstractListModel
implements ComboBoxModel {
    private final SelectionInList selectionInList;
    private final ValueModel selectionHolder;

    public ComboBoxAdapter(List items, ValueModel selectionHolder) {
        this(new SelectionInList(items), selectionHolder, false);
    }

    public ComboBoxAdapter(ListModel listModel, ValueModel selectionHolder) {
        this(new SelectionInList(listModel), selectionHolder, false);
    }

    public ComboBoxAdapter(Object[] items, ValueModel selectionHolder) {
        this(new SelectionInList(items), selectionHolder, false);
    }

    public ComboBoxAdapter(ValueModel listHolder, ValueModel selectionHolder) {
        this(new SelectionInList(listHolder), selectionHolder, false);
    }

    public ComboBoxAdapter(SelectionInList selectionInList) {
        this(selectionInList, null, true);
    }

    protected ComboBoxAdapter(SelectionInList selectionInList, ValueModel selectionHolder, boolean ignoreNullSelectionHolder) {
        if (!ignoreNullSelectionHolder && selectionHolder == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        if (selectionInList == null) {
            throw new NullPointerException("The SelectionInList must not be null.");
        }
        this.selectionInList = selectionInList;
        this.selectionHolder = selectionHolder;
        this.getSelectionHolder().addValueChangeListener(new SelectionChangeHandler());
        selectionInList.addListDataListener(new ListDataChangeHandler());
    }

    public Object getSelectedItem() {
        return this.getSelectionHolder().getValue();
    }

    public void setSelectedItem(Object object) {
        this.getSelectionHolder().setValue(object);
    }

    public int getSize() {
        return this.selectionInList.getSize();
    }

    public Object getElementAt(int index) {
        return this.selectionInList.getElementAt(index);
    }

    private ValueModel getSelectionHolder() {
        return this.selectionHolder != null ? this.selectionHolder : this.selectionInList;
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalAdded(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            ComboBoxAdapter.this.fireIntervalRemoved(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }

        public void contentsChanged(ListDataEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, evt.getIndex0(), evt.getIndex1());
        }
    }

    private final class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ComboBoxAdapter.this.fireContentsChanged(ComboBoxAdapter.this, -1, -1);
        }
    }
}

