/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.beans;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Timer;

public abstract class DelayedPropertyChangeHandler
implements PropertyChangeListener {
    public static final int DEFAULT_DELAY = 200;
    private final Timer timer;
    private boolean coalesce;
    private PropertyChangeEvent pendingEvt;

    public DelayedPropertyChangeHandler() {
        this(200);
    }

    public DelayedPropertyChangeHandler(int delay) {
        this(delay, false);
    }

    public DelayedPropertyChangeHandler(int delay, boolean coalesce) {
        this.coalesce = coalesce;
        this.timer = new Timer(delay, new DelayHandler());
        this.timer.setRepeats(false);
    }

    public boolean isCoalesce() {
        return this.coalesce;
    }

    public void setCoalesce(boolean b) {
        this.coalesce = b;
    }

    public final void stop() {
        this.timer.stop();
    }

    public final void propertyChange(PropertyChangeEvent evt) {
        this.pendingEvt = evt;
        if (this.coalesce) {
            this.timer.restart();
        } else {
            this.timer.start();
        }
    }

    public abstract void delayedPropertyChange(PropertyChangeEvent var1);

    private final class DelayHandler
    implements ActionListener {
        private DelayHandler() {
        }

        public void actionPerformed(ActionEvent e) {
            DelayedPropertyChangeHandler.this.delayedPropertyChange(DelayedPropertyChangeHandler.this.pendingEvt);
            DelayedPropertyChangeHandler.this.timer.stop();
        }
    }
}

