/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.AbstractValueModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public final class SelectionInList
extends AbstractValueModel
implements ListModel {
    public static final String PROPERTYNAME_LIST = "list";
    public static final String PROPERTYNAME_LIST_HOLDER = "listHolder";
    public static final String PROPERTYNAME_SELECTION = "selection";
    public static final String PROPERTYNAME_SELECTION_EMPTY = "selectionEmpty";
    public static final String PROPERTYNAME_SELECTION_HOLDER = "selectionHolder";
    public static final String PROPERTYNAME_SELECTION_INDEX = "selectionIndex";
    public static final String PROPERTYNAME_SELECTION_INDEX_HOLDER = "selectionIndexHolder";
    private static final int NO_SELECTION_INDEX = -1;
    private static final ListModel EMPTY_LIST_MODEL = new EmptyListModel();
    private ValueModel listHolder;
    private Object list;
    private ValueModel selectionHolder;
    private ValueModel selectionIndexHolder;
    private final PropertyChangeListener listChangeHandler;
    private final ListDataListener listDataChangeHandler;
    private final PropertyChangeListener selectionChangeHandler;
    private final PropertyChangeListener selectionIndexChangeHandler;
    private final EventListenerList listenerList = new EventListenerList();
    private Object oldSelection;
    private int oldSelectionIndex;

    public SelectionInList() {
        this(new ArrayListModel());
    }

    public SelectionInList(Object[] listItems) {
        this(Arrays.asList(listItems));
    }

    public SelectionInList(Object[] listItems, ValueModel selectionHolder) {
        this(Arrays.asList(listItems), selectionHolder);
    }

    public SelectionInList(Object[] listItems, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(Arrays.asList(listItems), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(List list) {
        this(new ValueHolder(list, true));
    }

    public SelectionInList(List list, ValueModel selectionHolder) {
        this(new ValueHolder(list, true), selectionHolder);
    }

    public SelectionInList(List list, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(new ValueHolder(list, true), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(ListModel listModel) {
        this(new ValueHolder(listModel, true));
    }

    public SelectionInList(ListModel listModel, ValueModel selectionHolder) {
        this(new ValueHolder(listModel, true), selectionHolder);
    }

    public SelectionInList(ListModel listModel, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        this(new ValueHolder(listModel, true), selectionHolder, selectionIndexHolder);
    }

    public SelectionInList(ValueModel listHolder) {
        this(listHolder, (ValueModel)new ValueHolder(null, true));
    }

    public SelectionInList(ValueModel listHolder, ValueModel selectionHolder) {
        this(listHolder, selectionHolder, (ValueModel)new ValueHolder(new Integer(-1)));
    }

    public SelectionInList(ValueModel listHolder, ValueModel selectionHolder, ValueModel selectionIndexHolder) {
        if (listHolder == null) {
            throw new NullPointerException("The list holder must not be null.");
        }
        if (selectionHolder == null) {
            throw new NullPointerException("The selection holder must not be null.");
        }
        if (selectionIndexHolder == null) {
            throw new NullPointerException("The selection index holder must not be null.");
        }
        this.checkListHolderIdentityCheck(listHolder);
        this.listChangeHandler = new ListChangeHandler();
        this.listDataChangeHandler = new ListDataChangeHandler();
        this.selectionChangeHandler = new SelectionChangeHandler();
        this.selectionIndexChangeHandler = new SelectionIndexChangeHandler();
        this.listHolder = listHolder;
        this.selectionHolder = selectionHolder;
        this.selectionIndexHolder = selectionIndexHolder;
        this.initializeSelectionIndex();
        this.listHolder.addValueChangeListener(this.listChangeHandler);
        this.selectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
        this.list = listHolder.getValue();
        if (this.list != null) {
            if (this.list instanceof ListModel) {
                ((ListModel)this.list).addListDataListener(this.listDataChangeHandler);
            } else if (!(this.list instanceof List)) {
                throw new ClassCastException("The listHolder's value must be a List or ListModel.");
            }
        }
    }

    public int getSize() {
        return this.getSize(this.getListHolder().getValue());
    }

    private int getSize(Object aList) {
        if (aList == null) {
            return 0;
        }
        if (aList instanceof ListModel) {
            return ((ListModel)aList).getSize();
        }
        return ((List)aList).size();
    }

    public Object getElementAt(int index) {
        return this.getElementAt(this.getListHolder().getValue(), index);
    }

    private Object getElementAt(Object aList, int index) {
        if (aList == null) {
            throw new NullPointerException("The list contents is null.");
        }
        if (aList instanceof ListModel) {
            return ((ListModel)aList).getElementAt(index);
        }
        return ((List)aList).get(index);
    }

    private Object getSafeElementAt(int index) {
        return index < 0 || index >= this.getSize() ? null : this.getElementAt(index);
    }

    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(ListDataListener.class);
    }

    public void fireSelectedContentsChanged() {
        if (this.hasSelection()) {
            int selectionIndex = this.getSelectionIndex();
            this.fireContentsChanged(selectionIndex, selectionIndex);
        }
    }

    public void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    public void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    public void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? SelectionInList.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    public boolean isEmpty() {
        return this.getSize() == 0;
    }

    public ListModel getListModel() {
        Object aList = this.getListHolder().getValue();
        if (aList == null) {
            return EMPTY_LIST_MODEL;
        }
        if (aList instanceof ListModel) {
            return (ListModel)aList;
        }
        return new ListModelAdapter((List)aList);
    }

    public void setListModel(ListModel newListModel) {
        this.getListHolder().setValue(newListModel);
    }

    public void setList(List newList) {
        this.getListHolder().setValue(newList);
    }

    public Object getSelection() {
        return this.getSafeElementAt(this.getSelectionIndex());
    }

    public void setSelection(Object newSelection) {
        if (!this.isEmpty()) {
            this.setSelectionIndex(this.indexOf(newSelection));
        }
    }

    public boolean hasSelection() {
        return this.getSelectionIndex() != -1;
    }

    public boolean isSelectionEmpty() {
        return !this.hasSelection();
    }

    public void clearSelection() {
        this.setSelectionIndex(-1);
    }

    public int getSelectionIndex() {
        return (Integer)this.getSelectionIndexHolder().getValue();
    }

    public void setSelectionIndex(int newSelectionIndex) {
        if (newSelectionIndex < -1 || newSelectionIndex > this.getSize()) {
            throw new IndexOutOfBoundsException("The selection index " + newSelectionIndex + " must be in [-1, " + this.getSize() + "]");
        }
        this.oldSelectionIndex = this.getSelectionIndex();
        if (this.oldSelectionIndex == newSelectionIndex) {
            return;
        }
        this.getSelectionIndexHolder().setValue(new Integer(newSelectionIndex));
    }

    public ValueModel getListHolder() {
        return this.listHolder;
    }

    public void setListHolder(ValueModel newListHolder) {
        if (newListHolder == null) {
            throw new NullPointerException("The new list holder must not be null.");
        }
        this.checkListHolderIdentityCheck(newListHolder);
        ValueModel oldListHolder = this.getListHolder();
        if (this.equals(oldListHolder, newListHolder)) {
            return;
        }
        Object oldList = this.list;
        Object newList = newListHolder.getValue();
        oldListHolder.removeValueChangeListener(this.listChangeHandler);
        this.listHolder = newListHolder;
        newListHolder.addValueChangeListener(this.listChangeHandler);
        this.updateList(oldList, newList);
        this.firePropertyChange(PROPERTYNAME_LIST_HOLDER, oldListHolder, newListHolder);
    }

    public ValueModel getSelectionHolder() {
        return this.selectionHolder;
    }

    public void setSelectionHolder(ValueModel newSelectionHolder) {
        if (newSelectionHolder == null) {
            throw new NullPointerException("The new selection holder must not be null.");
        }
        ValueModel oldSelectionHolder = this.getSelectionHolder();
        if (this.equals(oldSelectionHolder, newSelectionHolder)) {
            return;
        }
        oldSelectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionHolder = newSelectionHolder;
        this.oldSelection = newSelectionHolder.getValue();
        newSelectionHolder.addValueChangeListener(this.selectionChangeHandler);
        this.firePropertyChange(PROPERTYNAME_SELECTION_HOLDER, oldSelectionHolder, newSelectionHolder);
    }

    public ValueModel getSelectionIndexHolder() {
        return this.selectionIndexHolder;
    }

    public void setSelectionIndexHolder(ValueModel newSelectionIndexHolder) {
        if (newSelectionIndexHolder == null) {
            throw new NullPointerException("The new selection index holder must not be null.");
        }
        if (newSelectionIndexHolder.getValue() == null) {
            throw new IllegalArgumentException("The value of the new selection index holder must not be null.");
        }
        ValueModel oldSelectionIndexHolder = this.getSelectionIndexHolder();
        if (this.equals(oldSelectionIndexHolder, newSelectionIndexHolder)) {
            return;
        }
        oldSelectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
        this.selectionIndexHolder = newSelectionIndexHolder;
        newSelectionIndexHolder.addValueChangeListener(this.selectionIndexChangeHandler);
        this.oldSelectionIndex = this.getSelectionIndex();
        this.oldSelection = this.getSafeElementAt(this.oldSelectionIndex);
        this.firePropertyChange(PROPERTYNAME_SELECTION_INDEX_HOLDER, oldSelectionIndexHolder, newSelectionIndexHolder);
    }

    public Object getValue() {
        return this.getSelection();
    }

    public void setValue(Object newValue) {
        this.setSelection(newValue);
    }

    public void release() {
        this.listHolder.removeValueChangeListener(this.listChangeHandler);
        this.selectionHolder.removeValueChangeListener(this.selectionChangeHandler);
        this.selectionIndexHolder.removeValueChangeListener(this.selectionIndexChangeHandler);
        if (this.list != null && this.list instanceof ListModel) {
            ((ListModel)this.list).removeListDataListener(this.listDataChangeHandler);
        }
    }

    protected int indexOf(Object element) {
        return this.indexOf(this.getListHolder().getValue(), element);
    }

    private int indexOf(Object aList, Object element) {
        if (element == null) {
            return -1;
        }
        if (this.getSize(aList) == 0) {
            return -1;
        }
        if (aList instanceof List) {
            return ((List)aList).indexOf(element);
        }
        ListModel listModel = (ListModel)aList;
        int size = listModel.getSize();
        for (int index = 0; index < size; ++index) {
            if (!element.equals(listModel.getElementAt(index))) continue;
            return index;
        }
        return -1;
    }

    private void initializeSelectionIndex() {
        Object selectionValue = this.selectionHolder.getValue();
        if (selectionValue != null) {
            this.setSelectionIndex(this.indexOf(selectionValue));
        }
        this.oldSelection = selectionValue;
        this.oldSelectionIndex = this.getSelectionIndex();
    }

    private void updateList(Object oldList, Object newList) {
        boolean hadSelection;
        if (oldList != null && oldList instanceof ListModel) {
            ((ListModel)oldList).removeListDataListener(this.listDataChangeHandler);
        }
        if (newList != null && newList instanceof ListModel) {
            ((ListModel)newList).addListDataListener(this.listDataChangeHandler);
        }
        Object oldSelectionHolderValue = (hadSelection = this.hasSelection()) ? this.getSelectionHolder().getValue() : null;
        this.list = newList;
        this.firePropertyChange(PROPERTYNAME_LIST, oldList, newList);
        this.fireListChanged(this.getSize(oldList) - 1, this.getSize(newList) - 1);
        if (hadSelection) {
            this.setSelectionIndex(this.indexOf(newList, oldSelectionHolderValue));
        }
    }

    private void fireListChanged(int oldLastIndex, int newLastIndex) {
        if (newLastIndex < oldLastIndex) {
            this.fireIntervalRemoved(newLastIndex + 1, oldLastIndex);
        } else if (oldLastIndex < newLastIndex) {
            this.fireIntervalAdded(oldLastIndex + 1, newLastIndex);
        }
        int lastCommonIndex = Math.min(oldLastIndex, newLastIndex);
        if (lastCommonIndex >= 0) {
            this.fireContentsChanged(0, lastCommonIndex);
        }
    }

    private void checkListHolderIdentityCheck(ValueModel aListHolder) throws IllegalArgumentException {
        if (!(aListHolder instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)aListHolder;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The list holder must have the identity check enabled.");
        }
    }

    private final class SelectionIndexChangeHandler
    implements PropertyChangeListener {
        private SelectionIndexChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object newSelection;
            int newSelectionIndex = SelectionInList.this.getSelectionIndex();
            Object theOldSelection = SelectionInList.this.oldSelection;
            if (!SelectionInList.this.equals(theOldSelection, newSelection = SelectionInList.this.getSafeElementAt(newSelectionIndex))) {
                SelectionInList.this.selectionHolder.removeValueChangeListener(SelectionInList.this.selectionChangeHandler);
                SelectionInList.this.selectionHolder.setValue(newSelection);
                SelectionInList.this.selectionHolder.addValueChangeListener(SelectionInList.this.selectionChangeHandler);
            }
            int theOldSelectionIndex = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = newSelectionIndex;
            SelectionInList.this.oldSelection = newSelection;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, theOldSelectionIndex, newSelectionIndex);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, theOldSelectionIndex == -1, newSelectionIndex == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, theOldSelection, newSelection);
            SelectionInList.this.fireValueChange(theOldSelection, newSelection);
        }
    }

    private final class SelectionChangeHandler
    implements PropertyChangeListener {
        private SelectionChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldValue = evt.getOldValue();
            Object newSelection = evt.getNewValue();
            int newSelectionIndex = SelectionInList.this.indexOf(newSelection);
            if (newSelectionIndex != SelectionInList.this.oldSelectionIndex) {
                SelectionInList.this.selectionIndexHolder.removeValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
                SelectionInList.this.selectionIndexHolder.setValue(new Integer(newSelectionIndex));
                SelectionInList.this.selectionIndexHolder.addValueChangeListener(SelectionInList.this.selectionIndexChangeHandler);
            }
            int theOldSelectionIndex = SelectionInList.this.oldSelectionIndex;
            SelectionInList.this.oldSelectionIndex = newSelectionIndex;
            SelectionInList.this.oldSelection = newSelection;
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_INDEX, theOldSelectionIndex, newSelectionIndex);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION_EMPTY, theOldSelectionIndex == -1, newSelectionIndex == -1);
            SelectionInList.this.firePropertyChange(SelectionInList.PROPERTYNAME_SELECTION, oldValue, newSelection);
            SelectionInList.this.fireValueChange(oldValue, newSelection);
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent evt) {
            int index0 = evt.getIndex0();
            int index1 = evt.getIndex1();
            int index = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalAdded(index0, index1);
            if (index >= index0) {
                SelectionInList.this.setSelectionIndex(index + (index1 - index0 + 1));
            }
        }

        public void intervalRemoved(ListDataEvent evt) {
            int index0 = evt.getIndex0();
            int index1 = evt.getIndex1();
            int index = SelectionInList.this.getSelectionIndex();
            SelectionInList.this.fireIntervalRemoved(index0, index1);
            if (index >= index0) {
                if (index <= index1) {
                    SelectionInList.this.setSelectionIndex(-1);
                } else {
                    SelectionInList.this.setSelectionIndex(index - (index1 - index0 + 1));
                }
            }
        }

        public void contentsChanged(ListDataEvent evt) {
            SelectionInList.this.fireContentsChanged(evt.getIndex0(), evt.getIndex1());
            this.updateSelectionContentsChanged(evt.getIndex0(), evt.getIndex1());
        }

        private void updateSelectionContentsChanged(int first, int last) {
            if (first < 0) {
                return;
            }
            int selectionIndex = SelectionInList.this.getSelectionIndex();
            if (first <= selectionIndex && selectionIndex <= last) {
                SelectionInList.this.getSelectionHolder().setValue(SelectionInList.this.getElementAt(selectionIndex));
            }
        }
    }

    private final class ListChangeHandler
    implements PropertyChangeListener {
        private ListChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object oldList = SelectionInList.this.list;
            Object newList = evt.getNewValue();
            SelectionInList.this.updateList(oldList, newList);
        }
    }

    private static final class ListModelAdapter
    extends AbstractListModel {
        private final List aList;

        ListModelAdapter(List list) {
            this.aList = list;
        }

        public int getSize() {
            return this.aList.size();
        }

        public Object getElementAt(int index) {
            return this.aList.get(index);
        }
    }

    private static final class EmptyListModel
    implements ListModel,
    Serializable {
        private EmptyListModel() {
        }

        public int getSize() {
            return 0;
        }

        public Object getElementAt(int index) {
            return null;
        }

        public void addListDataListener(ListDataListener l) {
        }

        public void removeListDataListener(ListDataListener l) {
        }
    }
}

