/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.progress.module;

import java.awt.event.ActionEvent;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.progress.module.Controller;
import org.netbeans.progress.module.ProgressEvent;
import org.netbeans.progress.module.ui.NbProgressBar;
import org.openide.ErrorManager;
import org.openide.util.Cancellable;

public final class InternalHandle {
    private String displayName;
    private boolean allowCancel;
    private boolean allowBackground;
    private boolean customPlaced = false;
    private int state;
    private int totalUnits;
    private int currentUnit;
    private long initialEstimate;
    private long timeStarted;
    private long timeLastProgress;
    private String lastMessage;
    private final Cancellable cancelable;
    private final Action viewAction;
    private final boolean userInitiated;
    private int initialDelay = 500;
    private Controller controller;
    public static final int STATE_INITIALIZED = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_FINISHED = 2;
    public static final int STATE_REQUEST_STOP = 3;
    public static final int NO_INCREASE = -2;
    static final /* synthetic */ boolean $assertionsDisabled;

    public InternalHandle(String string, Cancellable cancellable, boolean bl, Action action) {
        this.displayName = string;
        this.userInitiated = bl;
        this.state = 0;
        this.totalUnits = 0;
        this.lastMessage = null;
        this.cancelable = cancellable;
        this.viewAction = action;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public synchronized int getState() {
        return this.state;
    }

    public boolean isAllowCancel() {
        return this.cancelable != null && !this.isCustomPlaced();
    }

    public boolean isAllowView() {
        return this.viewAction != null && !this.isCustomPlaced();
    }

    public boolean isCustomPlaced() {
        return this.customPlaced;
    }

    public boolean isUserInitialized() {
        return this.userInitiated;
    }

    private int getCurrentUnit() {
        return this.currentUnit;
    }

    public int getTotalUnits() {
        return this.totalUnits;
    }

    public void setInitialDelay(int n) {
        if (this.state != 0) {
            ErrorManager.getDefault().log(16, "Setting ProgressHandle.setInitialDelay() after the task is started has no effect");
            return;
        }
        this.initialDelay = n;
    }

    public int getInitialDelay() {
        return this.initialDelay;
    }

    public synchronized void toIndeterminate() {
        if (this.state != 1 && this.state != 3 && !$assertionsDisabled) {
            throw new AssertionError((Object)"cannot switch to indeterminate mode when not running");
        }
        this.totalUnits = 0;
        this.currentUnit = 0;
        this.initialEstimate = -1L;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toIndeterminate(this);
    }

    public synchronized void toDeterminate(int n, long l) {
        if (this.state != 1 && this.state != 3 && !$assertionsDisabled) {
            throw new AssertionError((Object)"cannot switch to determinate mode when not running");
        }
        if (n < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = n;
        this.currentUnit = 0;
        this.initialEstimate = l;
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.toDeterminate(this);
    }

    public synchronized void start(String string, int n, long l) {
        if (this.state != 0) {
            throw new IllegalStateException("Cannot call start twice on a handle");
        }
        if (n < 0) {
            throw new IllegalArgumentException("number of workunits cannot be negative");
        }
        this.totalUnits = n;
        this.currentUnit = 0;
        if (string != null) {
            this.lastMessage = string;
        }
        this.state = 1;
        this.initialEstimate = l;
        this.timeLastProgress = this.timeStarted = System.currentTimeMillis();
        if (!this.customPlaced) {
            this.controller = Controller.getDefault();
        }
        this.controller.start(this);
    }

    public synchronized void finish() {
        if (this.state == 0) {
            throw new IllegalStateException("Cannot finish not a started task");
        }
        if (this.state == 2) {
            return;
        }
        this.state = 2;
        this.currentUnit = this.totalUnits;
        this.controller.finish(this);
    }

    public synchronized void progress(String string, int n) {
        if (this.state != 1 && this.state != 3) {
            return;
        }
        if (n != -2) {
            if (n < this.currentUnit) {
                throw new IllegalArgumentException("Cannot decrease processed workunit count to lower value than before");
            }
            if (n > this.totalUnits) {
                ErrorManager.getDefault().log(16, "Warning: Cannot process more work than scheduled. Progress handle with name \"" + this.getDisplayName() + "\" has requested progress to workunit no." + n + " but the total number of workunits is " + this.totalUnits + ". That means the progress bar UI will not display real progress and will stay at 100%.");
                ErrorManager.getDefault().notify(1, (Throwable)new IllegalArgumentException());
                n = this.totalUnits;
            }
            this.currentUnit = n;
        }
        if (string != null) {
            this.lastMessage = string;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.progress(this, string, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestCancel() {
        if (!this.isAllowCancel()) {
            return;
        }
        InternalHandle internalHandle = this;
        synchronized (internalHandle) {
            this.state = 3;
        }
        this.cancelable.cancel();
        internalHandle = this;
        synchronized (internalHandle) {
            this.requestStateSnapshot();
        }
    }

    public void requestView() {
        if (!this.isAllowView()) {
            return;
        }
        this.viewAction.actionPerformed(new ActionEvent(this.viewAction, 1001, "performView"));
    }

    public synchronized void requestExplicitSelection() {
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.explicitSelection(this, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    public synchronized void requestDisplayNameChange(String string) {
        this.displayName = string;
        if (this.state == 0) {
            return;
        }
        this.timeLastProgress = System.currentTimeMillis();
        this.controller.displayNameChange(this, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate(), string);
    }

    public synchronized ProgressEvent requestStateSnapshot() {
        this.timeLastProgress = System.currentTimeMillis();
        return this.controller.snapshot(this, this.lastMessage, this.currentUnit, this.totalUnits > 0 ? this.getPercentageDone() : -1, this.initialEstimate == -1L ? -1L : this.calculateFinishEstimate());
    }

    public synchronized JComponent extractComponent() {
        if (this.customPlaced) {
            throw new IllegalStateException("Cannot retrieve progress component multiple times");
        }
        if (this.state != 0) {
            throw new IllegalStateException("You can request custom placement of progress component only before starting the task");
        }
        this.customPlaced = true;
        NbProgressBar nbProgressBar = new NbProgressBar();
        this.controller = new Controller(nbProgressBar);
        return nbProgressBar;
    }

    long calculateFinishEstimate() {
        double d = (double)(System.currentTimeMillis() - this.timeStarted) / 1000.0;
        if (this.initialEstimate == -1L) {
            return (long)(d * (double)(this.totalUnits - this.currentUnit) / (double)this.totalUnits);
        }
        long l = this.totalUnits - this.currentUnit;
        double d2 = (double)l / (double)this.totalUnits;
        double d3 = d / (double)this.currentUnit * (double)this.totalUnits;
        long l2 = (long)(((double)(this.initialEstimate * l) * d2 + d3 * (double)l * (1.0 - d2)) / (double)this.totalUnits);
        return l2;
    }

    public int getPercentageDone() {
        return (int)((long)this.currentUnit * 100L / (long)this.totalUnits);
    }

    long getTimeStampStarted() {
        return this.timeStarted;
    }

    static {
        $assertionsDisabled = !InternalHandle.class.desiredAssertionStatus();
    }
}

