/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.service.dhcp;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.Enumeration;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.openthinclient.common.model.service.ClientService;
import org.openthinclient.common.model.service.RealmService;
import org.openthinclient.common.model.service.UnrecognizedClientService;
import org.openthinclient.ldap.DirectoryException;
import org.openthinclient.service.dhcp.BasePXEService;

public class SingleHomedBroadcastPXEService
extends BasePXEService {
    private InetAddress serverAddress;

    public SingleHomedBroadcastPXEService(RealmService realmService, ClientService clientService, UnrecognizedClientService unrecognizedClientService) throws DirectoryException {
        super(realmService, clientService, unrecognizedClientService);
    }

    @Override
    protected InetSocketAddress determineServerAddress(InetSocketAddress localAddress) {
        return new InetSocketAddress(this.serverAddress, 67);
    }

    @Override
    public void init(IoAcceptor acceptor, IoHandler handler, IoServiceConfig config) throws IOException {
        logger.warn("-------------------------------------------------------------");
        logger.warn("  Using SingleHomedBroadcastPXEService implementation. ");
        logger.warn("  This type of service might be problematic on multi-homed systems.");
        logger.warn("  (for more details, see log messages with level INFO)");
        logger.info("");
        this.serverAddress = this.getConfiguredServerAddress();
        InetSocketAddress listenPort = new InetSocketAddress(67);
        acceptor.bind((SocketAddress)listenPort, handler, config);
        logger.info("  Binding on " + listenPort);
        InetSocketAddress pxePort = new InetSocketAddress(4011);
        acceptor.bind((SocketAddress)pxePort, handler, config);
        logger.info("  Binding on " + pxePort);
        logger.warn("-------------------------------------------------------------");
    }

    private InetAddress getConfiguredServerAddress() {
        try {
            InetAddress ifAddress = null;
            Enumeration<NetworkInterface> i = NetworkInterface.getNetworkInterfaces();
            block2: while (i.hasMoreElements()) {
                NetworkInterface nif = i.nextElement();
                if (nif.isLoopback() || nif.isPointToPoint() || nif.isVirtual() || !nif.isUp()) continue;
                Enumeration<InetAddress> j = nif.getInetAddresses();
                while (j.hasMoreElements()) {
                    InetAddress address = j.nextElement();
                    if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                    ifAddress = address;
                    logger.info("  Using address " + ifAddress + " as source IP");
                    break block2;
                }
            }
            if (null == ifAddress) {
                logger.error("  No non loopback InterfaceAddress found at all");
                return null;
            }
            return ifAddress;
        }
        catch (SocketException e) {
            logger.error("  Can't determine network interface");
            return null;
        }
    }
}

