/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import org.exolab.castor.types.GMonthDay;
import org.exolab.castor.types.OperationNotSupportedException;

public class GDay
extends GMonthDay {
    private static final String DAY_FORMAT = "---dd";
    private static final String BAD_GDAY = "Bad gDay format: ";

    public GDay() {
    }

    public GDay(short day) {
        this.setDay(day);
    }

    public GDay(int day) {
        this.setDay((short)day);
    }

    public GDay(String gday) throws ParseException {
        this();
        GDay.parseGDayInternal(gday, this);
    }

    public Date toDate() {
        Date date = null;
        SimpleDateFormat df = new SimpleDateFormat(DAY_FORMAT);
        if (this.isUTC()) {
            SimpleTimeZone timeZone = new SimpleTimeZone(0, "UTC");
            int offset = 0;
            offset = (this.getZoneMinute() + this.getZoneHour() * 60) * 60 * 1000;
            offset = this.isZoneNegative() ? -offset : offset;
            timeZone.setRawOffset(offset);
            timeZone.setID(TimeZone.getAvailableIDs(offset)[0]);
            df.setTimeZone(timeZone);
        }
        try {
            date = df.parse(this.toString());
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
        return date;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append('-');
        result.append('-');
        result.append('-');
        result.append(this.getDay());
        if (result.length() == 4) {
            result.insert(3, 0);
        }
        if (this.isUTC()) {
            if (this.getZoneHour() == 0 && this.getZoneMinute() == 0) {
                result.append('Z');
            } else {
                StringBuffer timeZone = new StringBuffer();
                if (this.isZoneNegative()) {
                    timeZone.append('-');
                } else {
                    timeZone.append('+');
                }
                if (this.getZoneHour() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneHour());
                timeZone.append(':');
                if (this.getZoneMinute() / 10 == 0) {
                    timeZone.append(0);
                }
                timeZone.append(this.getZoneMinute());
                result.append(timeZone.toString());
                Object var2_2 = null;
            }
        }
        return result.toString();
    }

    public static Object parse(String str) throws ParseException {
        return GDay.parseGDay(str);
    }

    public static GDay parseGDay(String str) throws ParseException {
        GDay result = new GDay();
        return GDay.parseGDayInternal(str, result);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static GDay parseGDayInternal(String str, GDay result) throws ParseException {
        if (str == null) {
            throw new IllegalArgumentException("The string to be parsed must not be null.");
        }
        if (result == null) {
            result = new GDay();
        }
        char[] chars = str.toCharArray();
        int idx = 0;
        boolean hasNumber = false;
        boolean has2Digits = false;
        int number = -1;
        int number2 = 0;
        int flags = 31;
        block6: while (idx < chars.length) {
            char ch = chars[idx++];
            switch (ch) {
                case '-': {
                    if (flags == 31 && number == -1) {
                        flags = 15;
                    } else if (flags == 15 && number == -1) {
                        flags = 7;
                    } else if (flags == 7 && number == -1) {
                        flags = 3;
                    } else {
                        if (flags != 3) throw new ParseException(BAD_GDAY + str + "\nA gDay must follow the pattern ---DD(Z|((+|-)hh:mm)).", idx);
                        if (!has2Digits) throw new ParseException(BAD_GDAY + str + "\nThe day field must have 2 digits.", idx);
                        result.setDay((short)number);
                        flags = 1;
                        result.setUTC();
                        result.setZoneNegative(true);
                        number = -1;
                    }
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case 'Z': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GDAY + str + "\n'Z' " + "is wrongly placed.", idx);
                    }
                    result.setUTC();
                    continue block6;
                }
                case '+': {
                    if (flags != 3) {
                        throw new ParseException(BAD_GDAY + str + "\n'+' " + "is wrongly placed.", idx);
                    }
                    if (!has2Digits) throw new ParseException(BAD_GDAY + str + "\nThe day field must have 2 digits.", idx);
                    result.setDay((short)number);
                    result.setUTC();
                    flags = 1;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
                case ':': {
                    if (flags != 1) {
                        throw new ParseException(BAD_GDAY + str + "\n':' " + "is wrongly placed.", idx);
                    }
                    number2 = number;
                    number = -1;
                    flags = 0;
                    hasNumber = false;
                    has2Digits = false;
                    continue block6;
                }
            }
            if ('0' > ch || ch > '9') throw new ParseException(str + ": Invalid character: " + ch, idx);
            if (hasNumber) {
                number = (short)(number * 10 + (ch - 48));
                has2Digits = true;
                continue;
            }
            hasNumber = true;
            number = (short)(ch - 48);
        }
        if (flags != 3 && flags != 0) {
            throw new ParseException(BAD_GDAY + str + "\nA gDay must follow the pattern ---DD(Z|((+|-)hh:mm)).", idx);
        }
        if (flags == 3) {
            if (!has2Digits) throw new ParseException(BAD_GDAY + str + "\nThe day field must have 2 digits.", idx);
            result.setDay((short)number);
            return result;
        } else {
            if (flags != 0) return result;
            if (number == -1) throw new ParseException(str + "\n In a time zone, the minute field must always be present.", idx);
            result.setZone((short)number2, (short)number);
        }
        return result;
    }

    public short getMonth() {
        String err = "GDay: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }

    public void setMonth(short month) {
        String err = "GDay: couldn't access to the Month field.";
        throw new OperationNotSupportedException(err);
    }
}

