/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import org.openide.ErrorManager;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.util.Lookup;

final class ExternalUtil {
    private static Repository repository;

    ExternalUtil() {
    }

    public static Repository getRepository() {
        ExternalUtil.initialize();
        return repository;
    }

    public static void exception(Exception exception) {
        ErrorManager.getDefault().notify(1, (Throwable)exception);
    }

    public static Throwable copyAnnotation(Throwable throwable, Throwable throwable2) {
        return throwable.initCause(throwable2);
    }

    public static void annotate(Throwable throwable, String string) {
        ErrorManager.getDefault().annotate(throwable, string);
    }

    public static Throwable annotate(Throwable throwable, Throwable throwable2) {
        return ErrorManager.getDefault().annotate(throwable, throwable2);
    }

    public static void log(String string) {
        ErrorManager.getDefault().log(1, string);
    }

    public static Class findClass(String string) throws ClassNotFoundException {
        ExternalUtil.initialize();
        ClassLoader classLoader = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
        if (classLoader == null) {
            return Class.forName(string);
        }
        return Class.forName(string, true, classLoader);
    }

    private static void initialize() {
        if (!ExternalUtil.isInitialized()) {
            Lookup lookup = Lookup.getDefault();
            Repository repository = (Repository)lookup.lookup(Repository.class);
            ExternalUtil.setRepository(repository);
        }
    }

    private static synchronized boolean isInitialized() {
        return repository != null;
    }

    private static synchronized void setRepository(Repository repository) {
        ExternalUtil.repository = repository;
        if (ExternalUtil.repository == null) {
            ExternalUtil.repository = new Repository(FileUtil.createMemoryFileSystem());
        }
    }
}

