/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.ListenerList;

class FCLSupport {
    public static final int DATA_CREATED = 0;
    public static final int FOLDER_CREATED = 1;
    public static final int FILE_CHANGED = 2;
    public static final int FILE_DELETED = 3;
    public static final int FILE_RENAMED = 4;
    public static final int ATTR_CHANGED = 5;
    private ListenerList listeners;

    FCLSupport() {
    }

    final synchronized void addFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners == null) {
            this.listeners = new ListenerList(FileChangeListener.class);
        }
        this.listeners.add(fileChangeListener);
    }

    final synchronized void removeFileChangeListener(FileChangeListener fileChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(fileChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void dispatchEvent(FileEvent fileEvent, int n) {
        Object[] objectArray;
        FCLSupport fCLSupport = this;
        synchronized (fCLSupport) {
            if (this.listeners == null) {
                return;
            }
            objectArray = this.listeners.getAllListeners();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!(objectArray[i] instanceof FileChangeListener)) continue;
            FCLSupport.dispatchEvent((FileChangeListener)objectArray[i], fileEvent, n);
        }
    }

    static final void dispatchEvent(FileChangeListener fileChangeListener, FileEvent fileEvent, int n) {
        switch (n) {
            case 0: {
                fileChangeListener.fileDataCreated(fileEvent);
                break;
            }
            case 1: {
                fileChangeListener.fileFolderCreated(fileEvent);
                break;
            }
            case 2: {
                fileChangeListener.fileChanged(fileEvent);
                break;
            }
            case 3: {
                fileChangeListener.fileDeleted(fileEvent);
                break;
            }
            case 4: {
                fileChangeListener.fileRenamed((FileRenameEvent)fileEvent);
                break;
            }
            case 5: {
                fileChangeListener.fileAttributeChanged((FileAttributeEvent)fileEvent);
            }
        }
    }

    final synchronized boolean hasListeners() {
        return this.listeners != null && this.listeners.getAllListeners().length != 0;
    }
}

