/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Vector;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Enumerations;

public class FileSystemCapability {
    public static final FileSystemCapability ALL;
    public static final FileSystemCapability COMPILE;
    public static final FileSystemCapability EXECUTE;
    public static final FileSystemCapability DEBUG;
    public static final FileSystemCapability DOC;
    static final /* synthetic */ boolean $assertionsDisabled;

    public FileSystemCapability() {
        if (DOC == null) {
            return;
        }
        if (!$assertionsDisabled && !FileUtil.assertDeprecatedMethod()) {
            throw new AssertionError();
        }
    }

    public boolean capableOf(FileSystemCapability fileSystemCapability) {
        return fileSystemCapability == this;
    }

    public Enumeration fileSystems() {
        class FFS
        implements Enumerations.Processor {
            FFS() {
            }

            public Object process(Object object, Collection collection) {
                FileSystem fileSystem = (FileSystem)object;
                return fileSystem.getCapability().capableOf(FileSystemCapability.this) ? fileSystem : null;
            }
        }
        return Enumerations.filter((Enumeration)ExternalUtil.getRepository().fileSystems(), (Enumerations.Processor)new FFS());
    }

    public FileObject findResource(String string) {
        Enumeration enumeration = this.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public Enumeration findAllResources(String string) {
        Vector<FileObject> vector = new Vector<FileObject>(8);
        Enumeration enumeration = this.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.findResource(string);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    public final FileObject find(String string, String string2, String string3) {
        Enumeration enumeration = this.fileSystems();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            return fileObject;
        }
        return null;
    }

    public final Enumeration findAll(String string, String string2, String string3) {
        Enumeration enumeration = this.fileSystems();
        Vector<FileObject> vector = new Vector<FileObject>();
        while (enumeration.hasMoreElements()) {
            FileSystem fileSystem = (FileSystem)enumeration.nextElement();
            FileObject fileObject = fileSystem.find(string, string2, string3);
            if (fileObject == null) continue;
            vector.addElement(fileObject);
        }
        return vector.elements();
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    static {
        $assertionsDisabled = !FileSystemCapability.class.desiredAssertionStatus();
        ALL = new FileSystemCapability(){

            public boolean capableOf(FileSystemCapability fileSystemCapability) {
                return true;
            }
        };
        COMPILE = new FileSystemCapability();
        EXECUTE = new FileSystemCapability();
        DEBUG = new FileSystemCapability();
        DOC = new FileSystemCapability();
    }

    public static class Bean
    extends FileSystemCapability
    implements Serializable {
        static final long serialVersionUID = 627905674809532736L;
        private transient PropertyChangeSupport supp;
        private boolean compilation = true;
        private boolean execution = true;
        private boolean debug = true;
        private boolean doc = false;

        public boolean capableOf(FileSystemCapability fileSystemCapability) {
            if (fileSystemCapability == COMPILE) {
                return this.compilation;
            }
            if (fileSystemCapability == EXECUTE) {
                return this.execution;
            }
            if (fileSystemCapability == DEBUG) {
                return this.debug;
            }
            if (fileSystemCapability == DOC) {
                return this.doc;
            }
            if (fileSystemCapability == ALL) {
                return true;
            }
            if (!(fileSystemCapability instanceof Bean)) {
                return false;
            }
            Bean bean = (Bean)fileSystemCapability;
            return this.compilation == bean.compilation && this.execution == bean.execution && this.debug == bean.debug && this.doc == bean.doc;
        }

        public boolean getCompile() {
            return this.compilation;
        }

        public void setCompile(boolean bl) {
            if (bl != this.compilation) {
                this.compilation = bl;
                if (this.supp != null) {
                    this.supp.firePropertyChange("compile", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getExecute() {
            return this.execution;
        }

        public void setExecute(boolean bl) {
            if (bl != this.execution) {
                this.execution = bl;
                if (this.supp != null) {
                    this.supp.firePropertyChange("execute", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getDebug() {
            return this.debug;
        }

        public void setDebug(boolean bl) {
            if (bl != this.debug) {
                this.debug = bl;
                if (this.supp != null) {
                    this.supp.firePropertyChange("debug", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public boolean getDoc() {
            return this.doc;
        }

        public void setDoc(boolean bl) {
            if (bl != this.doc) {
                this.doc = bl;
                if (this.supp != null) {
                    this.supp.firePropertyChange("doc", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
                }
            }
        }

        public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.supp == null) {
                this.supp = new PropertyChangeSupport(this);
            }
            this.supp.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.supp != null) {
                this.supp.removePropertyChangeListener(propertyChangeListener);
            }
        }
    }
}

