/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.explorer;

import java.util.HashMap;
import java.util.Map;
import org.openide.util.Lookup;

public abstract class PsSettings {
    private static PsSettings defaultInstance = null;

    protected PsSettings() {
    }

    public static PsSettings getDefault() {
        if (defaultInstance == null && (defaultInstance = (PsSettings)Lookup.getDefault().lookup(PsSettings.class)) == null) {
            defaultInstance = new Trivial();
        }
        return defaultInstance;
    }

    public abstract int getInt(String var1, int var2);

    public abstract void putInt(String var1, int var2);

    public abstract void putBoolean(String var1, boolean var2);

    public abstract boolean getBoolean(String var1, boolean var2);

    public abstract void put(String var1, String var2);

    public abstract String get(String var1, String var2);

    private static class Trivial
    extends PsSettings {
        private Map map = new HashMap();

        private Trivial() {
        }

        public String get(String string, String string2) {
            String string3 = (String)this.map.get(string);
            if (string3 == null) {
                string3 = string2;
            }
            return string3;
        }

        public boolean getBoolean(String string, boolean bl) {
            Boolean bl2 = (Boolean)this.map.get(string);
            if (bl2 == null) {
                return bl;
            }
            return bl2;
        }

        public int getInt(String string, int n) {
            Integer n2 = (Integer)this.map.get(string);
            if (n2 == null) {
                return n;
            }
            return n2;
        }

        public void put(String string, String string2) {
            this.map.put(string, string2);
        }

        public void putBoolean(String string, boolean bl) {
            this.map.put(string, bl ? Boolean.TRUE : Boolean.FALSE);
        }

        public void putInt(String string, int n) {
            this.map.put(string, new Integer(n));
        }
    }
}

