/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragSource;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeNode;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.view.TreeViewDropSupport;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.UserCancelException;
import org.openide.util.Utilities;
import org.openide.util.datatransfer.ExClipboard;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.MultiTransferObject;
import org.openide.util.datatransfer.PasteType;

final class DragDropUtilities {
    static final boolean dragAndDropEnabled;
    static final int NODE_UP = -1;
    static final int NODE_CENTRAL = 0;
    static final int NODE_DOWN = 1;
    static final Point CURSOR_CENTRAL_POINT;
    static Runnable postDropRun;
    static final int NoDrag = 0;
    static final int NoDrop = 1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private DragDropUtilities() {
    }

    private static boolean isDragAndDropEnabled() {
        if (System.getProperty("netbeans.dnd.enabled") != null) {
            return Boolean.getBoolean("netbeans.dnd.enabled");
        }
        return true;
    }

    static Cursor chooseCursor(Component component, int n, boolean bl) {
        try {
            String string;
            Image image;
            switch (n) {
                case 1: {
                    if (bl) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorscopysingle.gif");
                        string = "ACTION_COPY";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_COPY";
                    break;
                }
                case 2: 
                case 3: {
                    if (bl) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorsmovesingle.gif");
                        string = "ACTION_MOVE";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_MOVE";
                    break;
                }
                case 0x40000000: {
                    if (bl) {
                        image = Utilities.loadImage((String)"org/openide/resources/cursorsunknownsingle.gif");
                        string = "ACTION_LINK";
                        break;
                    }
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    string = "NO_ACTION_LINK";
                    break;
                }
                default: {
                    image = Utilities.loadImage((String)"org/openide/resources/cursorsnone.gif");
                    string = "ACTION_NONE";
                }
            }
            return Utilities.createCustomCursor((Component)component, (Image)image, (String)string);
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
            return DragSource.DefaultMoveNoDrop;
        }
    }

    static boolean checkNodeForAction(Node node, int n) {
        if (node.canCut() && (n == 2 || n == 3)) {
            return true;
        }
        return node.canCopy() && (n == 1 || n == 3 || n == 0x40000000 || n == 0x40000000);
    }

    static Transferable getNodeTransferable(Node[] nodeArray, int n) throws IOException {
        Transferable[] transferableArray = new Transferable[nodeArray.length];
        for (int i = 0; i < nodeArray.length; ++i) {
            transferableArray[i] = (n & 2) != 0 ? nodeArray[i].clipboardCut() : nodeArray[i].drag();
        }
        Transferable transferable = transferableArray.length == 1 ? transferableArray[0] : new ExTransferable.Multi(transferableArray);
        Clipboard clipboard = DragDropUtilities.getClipboard();
        if (clipboard instanceof ExClipboard) {
            return ((ExClipboard)clipboard).convert(transferable);
        }
        return transferable;
    }

    static Transferable getNodeTransferable(Node node, int n) throws IOException {
        return DragDropUtilities.getNodeTransferable(new Node[]{node}, n);
    }

    static void setPostDropRun(Runnable runnable) {
        postDropRun = runnable;
    }

    private static void invokePostDropRun() {
        if (postDropRun != null) {
            SwingUtilities.invokeLater(postDropRun);
            postDropRun = null;
        }
    }

    static Node[] performPaste(PasteType pasteType, Node node) {
        try {
            if (node == null) {
                pasteType.paste();
                return new Node[0];
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            pasteType.paste();
            Node[] nodeArray2 = node.getChildren().getNodes(true);
            List<Node> list = Arrays.asList(nodeArray);
            List<Node> list2 = Arrays.asList(nodeArray2);
            Iterator<Node> iterator = list2.iterator();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            while (iterator.hasNext()) {
                Node node2 = iterator.next();
                if (list.contains(node2)) continue;
                arrayList.add(node2);
            }
            return arrayList.toArray(new Node[arrayList.size()]);
        }
        catch (UserCancelException userCancelException) {
            return new Node[0];
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
            return new Node[0];
        }
    }

    static PasteType[] getPasteTypes(Node node, Transferable transferable) {
        if (!transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            PasteType[] pasteTypeArray = null;
            try {
                pasteTypeArray = node.getPasteTypes(transferable);
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().notify((Throwable)nullPointerException);
            }
            return pasteTypeArray;
        }
        try {
            MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
            int n = multiTransferObject.getCount();
            Transferable[] transferableArray = new Transferable[n];
            PasteType[] pasteTypeArray = new PasteType[n];
            PasteType[] pasteTypeArray2 = null;
            for (int i = 0; i < n; ++i) {
                transferableArray[i] = multiTransferObject.getTransferableAt(i);
                pasteTypeArray2 = node.getPasteTypes(transferableArray[i]);
                if (pasteTypeArray2.length == 0) {
                    return pasteTypeArray2;
                }
                pasteTypeArray[i] = pasteTypeArray2[0];
            }
            return new PasteType[]{new MultiPasteType(transferableArray, pasteTypeArray)};
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new PasteType[0];
    }

    static PasteType getDropType(Node node, Transferable transferable, int n) {
        if (!transferable.isDataFlavorSupported(ExTransferable.multiFlavor)) {
            PasteType pasteType = null;
            try {
                pasteType = node.getDropType(transferable, n, -1);
            }
            catch (NullPointerException nullPointerException) {
                ErrorManager.getDefault().notify((Throwable)nullPointerException);
            }
            return pasteType;
        }
        try {
            MultiTransferObject multiTransferObject = (MultiTransferObject)transferable.getTransferData(ExTransferable.multiFlavor);
            int n2 = multiTransferObject.getCount();
            Transferable[] transferableArray = new Transferable[n2];
            PasteType[] pasteTypeArray = new PasteType[n2];
            PasteType pasteType = null;
            for (int i = 0; i < n2; ++i) {
                transferableArray[i] = multiTransferObject.getTransferableAt(i);
                pasteType = node.getDropType(transferableArray[i], n, -1);
                if (pasteType == null) {
                    return pasteType;
                }
                pasteTypeArray[i] = pasteType;
            }
            return new MultiPasteType(transferableArray, pasteTypeArray);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static void dropNotSuccesfull() {
        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getBundle((Class)TreeViewDropSupport.class).getString("MSG_NoPasteTypes"), 2));
    }

    private static Clipboard getClipboard() {
        Clipboard clipboard = (Clipboard)Lookup.getDefault().lookup(Clipboard.class);
        if (clipboard == null) {
            clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        return clipboard;
    }

    static Node secureFindNode(Object object) {
        if (!$assertionsDisabled && !(object instanceof TreeNode)) {
            throw new AssertionError((Object)("Object " + object + " is instanceof TreeNode"));
        }
        try {
            return Visualizer.findNode(object);
        }
        catch (ClassCastException classCastException) {
            classCastException.printStackTrace();
            return null;
        }
    }

    static JPopupMenu createDropFinishPopup(final TreeSet treeSet) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        final JMenuItem[] jMenuItemArray = new JMenuItem[treeSet.size()];
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
                Iterator iterator = treeSet.iterator();
                int n = 0;
                while (iterator.hasNext()) {
                    PasteType pasteType = (PasteType)iterator.next();
                    if (jMenuItemArray[n].equals(jMenuItem)) {
                        DragDropUtilities.performPaste(pasteType, null);
                        DragDropUtilities.invokePostDropRun();
                        break;
                    }
                    ++n;
                }
            }
        };
        Iterator iterator = treeSet.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            jMenuItemArray[n] = new JMenuItem();
            Mnemonics.setLocalizedText((AbstractButton)jMenuItemArray[n], (String)((PasteType)iterator.next()).getName());
            jMenuItemArray[n].addActionListener(actionListener);
            jPopupMenu.add(jMenuItemArray[n]);
            ++n;
        }
        jPopupMenu.addSeparator();
        JMenuItem jMenuItem = new JMenuItem(NbBundle.getBundle((Class)DragDropUtilities.class).getString("MSG_ABORT"));
        jPopupMenu.add(jMenuItem);
        return jPopupMenu;
    }

    static {
        $assertionsDisabled = !DragDropUtilities.class.desiredAssertionStatus();
        dragAndDropEnabled = DragDropUtilities.isDragAndDropEnabled();
        CURSOR_CENTRAL_POINT = new Point(10, 10);
        postDropRun = null;
    }

    static final class MultiPasteType
    extends PasteType {
        Transferable[] t;
        PasteType[] p;

        MultiPasteType(Transferable[] transferableArray, PasteType[] pasteTypeArray) {
            this.t = transferableArray;
            this.p = pasteTypeArray;
        }

        public Transferable paste() throws IOException {
            int n = this.p.length;
            Transferable[] transferableArray = new Transferable[n];
            for (int i = 0; i < n; ++i) {
                transferableArray[i] = this.p[i].paste();
            }
            return new ExTransferable.Multi(transferableArray);
        }
    }
}

