/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Cursor;
import java.awt.datatransfer.Transferable;
import java.util.Iterator;
import javax.swing.JScrollPane;
import org.openide.explorer.view.ListView;
import org.openide.explorer.view.TreeView;
import org.openide.nodes.Node;
import org.openide.util.WeakSet;

final class ExplorerDnDManager {
    private static ExplorerDnDManager defaultDnDManager;
    private Node[] draggedNodes;
    private Transferable draggedTransForCut;
    private Transferable draggedTransForCopy;
    private boolean isDnDActive = false;
    private int nodeAllowed = 0;
    private Cursor cursor = null;
    private transient WeakSet setOfTargets;

    private ExplorerDnDManager() {
    }

    static synchronized ExplorerDnDManager getDefault() {
        if (defaultDnDManager == null) {
            defaultDnDManager = new ExplorerDnDManager();
        }
        return defaultDnDManager;
    }

    void setDraggedNodes(Node[] nodeArray) {
        this.draggedNodes = nodeArray;
    }

    Node[] getDraggedNodes() {
        return this.draggedNodes;
    }

    void setDraggedTransferable(Transferable transferable, boolean bl) {
        if (bl) {
            this.draggedTransForCut = transferable;
        } else {
            this.draggedTransForCopy = transferable;
        }
    }

    Transferable getDraggedTransferable(boolean bl) {
        if (bl) {
            return this.draggedTransForCut;
        }
        return this.draggedTransForCopy;
    }

    void setNodeAllowedActions(int n) {
        this.nodeAllowed = n;
    }

    final int getNodeAllowedActions() {
        return this.nodeAllowed;
    }

    void setDnDActive(boolean bl) {
        this.isDnDActive = bl;
        if (this.setOfTargets != null && !this.setOfTargets.isEmpty()) {
            Iterator iterator = this.setOfTargets.iterator();
            while (iterator.hasNext()) {
                JScrollPane jScrollPane = (JScrollPane)iterator.next();
                if (!jScrollPane.isEnabled()) continue;
                if (jScrollPane instanceof TreeView) {
                    ((TreeView)jScrollPane).setDropTarget(bl);
                    continue;
                }
                if (!(jScrollPane instanceof ListView)) continue;
                ((ListView)jScrollPane).setDropTarget(bl);
            }
        }
    }

    boolean isDnDActive() {
        return this.isDnDActive;
    }

    void addFutureDropTarget(JScrollPane jScrollPane) {
        if (this.setOfTargets == null) {
            this.setOfTargets = new WeakSet();
        }
        this.setOfTargets.add((Object)jScrollPane);
    }

    int getAdjustedDropAction(int n, int n2) {
        int n3 = n;
        if ((n3 & n2) == 0) {
            n3 = n2;
        }
        if ((n3 & this.nodeAllowed) == 0) {
            n3 = this.nodeAllowed;
        }
        return n3;
    }

    void prepareCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    Cursor getCursor() {
        return this.cursor;
    }
}

