/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.tree.TreeNode;
import org.openide.ErrorManager;
import org.openide.explorer.view.NodeModel;
import org.openide.explorer.view.VisualizerChildren;
import org.openide.explorer.view.VisualizerEvent;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.nodes.NodeMemberEvent;
import org.openide.nodes.NodeOp;
import org.openide.nodes.NodeReorderEvent;
import org.openide.util.Mutex;
import org.openide.util.Utilities;

final class VisualizerNode
extends EventListenerList
implements NodeListener,
TreeNode,
Runnable {
    private static final VisualizerNode TEMPLATE;
    private static final Reference NO_REF;
    private static WeakHashMap cache;
    public static final VisualizerNode EMPTY;
    private static final QP QUEUE;
    private static final ErrorManager err;
    private static final String UNKNOWN;
    static final long serialVersionUID = 3726728244698316872L;
    private static final String NO_HTML_DISPLAYNAME = "noHtmlDisplayName";
    private static Icon defaultIcon;
    private static final String DEFAULT_ICON = "org/openide/resources/defaultNode.gif";
    private Icon icon = null;
    Node node;
    private int hashCode;
    private Reference children = NO_REF;
    private VisualizerChildren parent;
    private String name;
    private String displayName;
    private String shortDescription;
    private transient boolean inRead;
    private String htmlDisplayName = null;
    private int cachedIconType = -1;
    static final /* synthetic */ boolean $assertionsDisabled;

    private VisualizerNode(int n) {
        this.hashCode = n;
        this.node = null;
    }

    private VisualizerNode(Node node) {
        this.node = node;
        this.hashCode = System.identityHashCode(this.node);
        this.node.addNodeListener(NodeOp.weakNodeListener((NodeListener)this, (Object)this.node));
        this.name = UNKNOWN;
        this.displayName = UNKNOWN;
        this.shortDescription = UNKNOWN;
    }

    public static VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node) {
        return VisualizerNode.getVisualizer(visualizerChildren, node, true);
    }

    public static synchronized VisualizerNode getVisualizer(VisualizerChildren visualizerChildren, Node node, boolean bl) {
        VisualizerNode visualizerNode;
        VisualizerNode.TEMPLATE.hashCode = System.identityHashCode(node);
        VisualizerNode.TEMPLATE.node = node;
        Reference reference = (Reference)cache.get(TEMPLATE);
        VisualizerNode.TEMPLATE.hashCode = 0;
        VisualizerNode.TEMPLATE.node = null;
        VisualizerNode visualizerNode2 = visualizerNode = reference == null ? null : (VisualizerNode)reference.get();
        if (visualizerNode == null) {
            if (!bl) {
                return null;
            }
            visualizerNode = new VisualizerNode(node);
            cache.put(visualizerNode, new WeakReference<VisualizerNode>(visualizerNode));
        }
        if (visualizerChildren != null) {
            visualizerNode.parent = visualizerChildren;
        }
        return visualizerNode;
    }

    public String getShortDescription() {
        String string = this.shortDescription;
        if (string == UNKNOWN) {
            this.shortDescription = string = this.node.getShortDescription();
        }
        return string;
    }

    public String getDisplayName() {
        if (this.displayName == UNKNOWN) {
            this.displayName = this.node == null ? null : this.node.getDisplayName();
        }
        return this.displayName;
    }

    public String getName() {
        if (this.name == UNKNOWN) {
            this.name = this.node == null ? null : this.node.getName();
        }
        return this.name;
    }

    public List getChildren() {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null && !this.node.isLeaf()) {
            Node[] nodeArray = this.node.getChildren().getNodes();
            visualizerChildren = (VisualizerChildren)Children.MUTEX.readAccess(new Mutex.Action(){

                public Object run() {
                    Node[] nodeArray = VisualizerNode.this.node.getChildren().getNodes();
                    VisualizerChildren visualizerChildren = new VisualizerChildren(VisualizerNode.this, nodeArray);
                    VisualizerNode.this.notifyVisualizerChildrenChange(nodeArray.length, visualizerChildren);
                    return visualizerChildren;
                }
            });
        }
        if (!$assertionsDisabled && visualizerChildren != null && visualizerChildren.list.contains(null)) {
            throw new AssertionError((Object)(visualizerChildren.list + " from " + this.node));
        }
        return visualizerChildren == null ? Collections.EMPTY_LIST : visualizerChildren.list;
    }

    public int getIndex(TreeNode treeNode) {
        return this.getChildren().indexOf(treeNode);
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public TreeNode getChildAt(int n) {
        List list = this.getChildren();
        VisualizerNode visualizerNode = (VisualizerNode)list.get(n);
        if (!$assertionsDisabled && visualizerNode == null) {
            throw new AssertionError((Object)("Null child in " + list + " from " + this.node));
        }
        return visualizerNode;
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public Enumeration children() {
        List list = this.getChildren();
        if (!$assertionsDisabled && list.contains(null)) {
            throw new AssertionError((Object)("Null child in " + list + " from " + this.node));
        }
        return Collections.enumeration(list);
    }

    public boolean isLeaf() {
        return this.node.isLeaf();
    }

    public TreeNode getParent() {
        Node node = this.node.getParentNode();
        return node == null ? null : VisualizerNode.getVisualizer(null, node);
    }

    public void childrenAdded(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Added(visualizerChildren, nodeMemberEvent.getDelta(), nodeMemberEvent.getDeltaIndices()));
    }

    public void childrenRemoved(NodeMemberEvent nodeMemberEvent) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Removed(visualizerChildren, nodeMemberEvent.getDelta()));
    }

    public void childrenReordered(NodeReorderEvent nodeReorderEvent) {
        this.doChildrenReordered(nodeReorderEvent.getPermutation());
    }

    void doChildrenReordered(int[] nArray) {
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        QUEUE.runSafe(new VisualizerEvent.Reordered(visualizerChildren, nArray));
    }

    void reorderChildren(Comparator comparator) {
        if (!$assertionsDisabled && !SwingUtilities.isEventDispatchThread()) {
            throw new AssertionError();
        }
        VisualizerChildren visualizerChildren = (VisualizerChildren)this.children.get();
        if (visualizerChildren == null) {
            return;
        }
        new VisualizerEvent.Reordered(visualizerChildren, comparator).run();
    }

    void naturalOrder() {
        this.children.clear();
        this.getChildren();
        this.reorderChildren(new Comparator(){

            public int compare(Object object, Object object2) {
                return 0;
            }
        });
    }

    public void nodeDestroyed(NodeEvent nodeEvent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl;
        String string = propertyChangeEvent.getPropertyName();
        boolean bl2 = bl = "icon".equals(string) || "openedIcon".equals(string);
        if ("name".equals(string) || "displayName".equals(string) || bl) {
            if (bl) {
                this.cachedIconType = -1;
            }
            if ("displayName".equals(string)) {
                this.htmlDisplayName = null;
            }
            SwingUtilities.invokeLater(this);
            return;
        }
        if ("shortDescription".equals(string) && this.shortDescription != UNKNOWN) {
            SwingUtilities.invokeLater(this);
            return;
        }
        if ("leaf".equals(string)) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    VisualizerNode.this.children = NO_REF;
                    for (VisualizerNode visualizerNode = VisualizerNode.this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
                        Object[] objectArray = visualizerNode.getListenerList();
                        for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                            ((NodeModel)objectArray[i]).structuralChange(VisualizerNode.this);
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (!this.inRead) {
            try {
                this.inRead = true;
                Children.MUTEX.readAccess((Runnable)this);
            }
            finally {
                this.inRead = false;
            }
            return;
        }
        this.name = this.node.getName();
        this.displayName = this.node.getDisplayName();
        this.shortDescription = UNKNOWN;
        for (VisualizerNode visualizerNode = this; visualizerNode != null; visualizerNode = (VisualizerNode)visualizerNode.getParent()) {
            Object[] objectArray = visualizerNode.getListenerList();
            for (int i = objectArray.length - 1; i >= 0; i -= 2) {
                ((NodeModel)objectArray[i]).update(this);
            }
        }
    }

    void notifyVisualizerChildrenChange(int n, VisualizerChildren visualizerChildren) {
        this.children = n == 0 ? new StrongReference(visualizerChildren) : new WeakReference<VisualizerChildren>(visualizerChildren);
    }

    public synchronized void addNodeModel(NodeModel nodeModel) {
        this.add(NodeModel.class, nodeModel);
    }

    public synchronized void removeNodeModel(NodeModel nodeModel) {
        this.remove(NodeModel.class, nodeModel);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (!(object instanceof VisualizerNode)) {
            return false;
        }
        VisualizerNode visualizerNode = (VisualizerNode)object;
        return visualizerNode.node == this.node;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getHtmlDisplayName() {
        if (this.htmlDisplayName == null) {
            this.htmlDisplayName = this.node.getHtmlDisplayName();
            if (this.htmlDisplayName == null) {
                this.htmlDisplayName = NO_HTML_DISPLAYNAME;
            }
        }
        return this.htmlDisplayName == NO_HTML_DISPLAYNAME ? null : this.htmlDisplayName;
    }

    Icon getIcon(boolean bl, boolean bl2) {
        int n = VisualizerNode.getCacheType(bl, bl2);
        if (this.cachedIconType != n) {
            Image image;
            int n2 = bl2 ? 2 : 1;
            Image image2 = image = bl ? this.node.getOpenedIcon(n2) : this.node.getIcon(n2);
            if (image == null) {
                String string = bl ? "getOpenedIcon" : "getIcon";
                ErrorManager.getDefault().log(16, "Node \"" + this.node.getName() + "\" [" + this.node.getClass().getName() + "] cannot return null from " + string + "(). See Node." + string + " contract.");
                this.icon = VisualizerNode.getDefaultIcon();
            } else {
                this.icon = new ImageIcon(image);
            }
        }
        this.cachedIconType = n;
        return this.icon;
    }

    private static final int getCacheType(boolean bl, boolean bl2) {
        return (bl ? 2 : 0) | (bl2 ? 1 : 0);
    }

    private static Icon getDefaultIcon() {
        if (defaultIcon == null) {
            defaultIcon = new ImageIcon(Utilities.loadImage((String)DEFAULT_ICON));
        }
        return defaultIcon;
    }

    static void runQueue() {
        QUEUE.run();
    }

    static {
        $assertionsDisabled = !VisualizerNode.class.desiredAssertionStatus();
        TEMPLATE = new VisualizerNode(0);
        NO_REF = new WeakReference<Object>(null);
        cache = new WeakHashMap();
        EMPTY = VisualizerNode.getVisualizer(null, Node.EMPTY);
        QUEUE = new QP();
        err = ErrorManager.getDefault().getInstance("org.openide.explorer.view.VisualizerNode");
        UNKNOWN = new String();
    }

    private static final class QP
    implements Runnable {
        private LinkedList queue = null;

        QP() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void runSafe(Runnable runnable) {
            boolean bl = false;
            QP qP = this;
            synchronized (qP) {
                if (this.queue == null) {
                    this.queue = new LinkedList();
                    bl = true;
                }
                this.queue.add(runnable);
            }
            if (bl) {
                Mutex.EVENT.writeAccess((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Enumeration enumeration;
            Runnable runnable = this;
            synchronized (runnable) {
                if (this.queue == null) {
                    return;
                }
                enumeration = Collections.enumeration(this.queue);
                this.queue = null;
            }
            while (enumeration.hasMoreElements()) {
                runnable = (Runnable)enumeration.nextElement();
                Children.MUTEX.readAccess(runnable);
            }
        }
    }

    private static final class StrongReference
    extends WeakReference {
        private Object o;

        public StrongReference(Object object) {
            super(null);
            this.o = object;
        }

        public Object get() {
            return this.o;
        }
    }
}

