/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.db;

import java.io.Serializable;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import org.openthinclient.pkgmgr.db.Source;
import org.openthinclient.pkgmgr.db.Version;
import org.openthinclient.util.dpkg.PackageReferenceList;

@Entity
@Table(name="otc_package")
@Access(value=AccessType.FIELD)
public class Package
implements Serializable,
Comparable<Package> {
    private static final long serialVersionUID = 3257006574903111730L;
    @Id
    @GeneratedValue
    private Long id;
    @ManyToOne
    @JoinColumn(name="source_id")
    private Source source;
    @Column
    private long installedSize;
    @Column
    private PackageReferenceList depends = new PackageReferenceList();
    @Column
    private PackageReferenceList conflicts = new PackageReferenceList();
    @Column
    private PackageReferenceList enhances = new PackageReferenceList();
    @Column(name="pre_depends")
    private PackageReferenceList preDepends = new PackageReferenceList();
    @Column
    private PackageReferenceList provides = new PackageReferenceList();
    @Column
    private PackageReferenceList recommends = new PackageReferenceList();
    @Column
    private PackageReferenceList replaces = new PackageReferenceList();
    @Embedded
    private Version version;
    @Column
    private String architecture;
    @Column(name="changed_by")
    private String changedBy;
    @Column(length=40, columnDefinition="char")
    private String date;
    @Column
    @Lob
    private String description;
    @Column(length=80)
    private String distribution;
    @Column
    private boolean essential;
    @Column
    private String maintainer;
    @Column
    private String name;
    @Column(length=10, columnDefinition="char")
    private String priority;
    @Column
    private String section;
    @Column
    private String filename;
    @Column(length=32, columnDefinition="char")
    private String md5sum;
    @Column
    private long size;
    @Column(name="description_short")
    @Lob
    private String shortDescription;
    @Column
    @Lob
    private String license;
    @Column
    private boolean installed;
    @Column
    @Lob
    private String changeLog;

    @PostLoad
    public void sanitizeValues() {
        if (this.priority != null) {
            this.priority = this.priority.trim();
        }
    }

    public Long getId() {
        return this.id;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public PackageReferenceList getConflicts() {
        return this.conflicts;
    }

    public void setConflicts(PackageReferenceList conflicts) {
        this.conflicts = conflicts;
    }

    public PackageReferenceList getDepends() {
        return this.depends;
    }

    public void setDepends(PackageReferenceList depends) {
        this.depends = depends;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public PackageReferenceList getPreDepends() {
        return this.preDepends;
    }

    public void setPreDepends(PackageReferenceList preDepends) {
        this.preDepends = preDepends;
    }

    public PackageReferenceList getProvides() {
        return this.provides;
    }

    public void setProvides(PackageReferenceList provides) {
        this.provides = provides;
    }

    public Version getVersion() {
        return this.version;
    }

    public String getDisplayVersion() {
        return this.version == null ? "" : this.version.getUpstreamVersion().concat(this.version.getDebianRevision() != null ? "-" + this.version.getDebianRevision() : "");
    }

    public void setVersion(String s) {
        this.version = Version.parse(s);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Package: ").append(this.getName()).append("\n");
        sb.append("  Version: ").append(this.getVersion()).append("\n");
        sb.append("  Architecture: ").append(this.getArchitecture()).append("\n");
        sb.append("  Changed-By: ").append(this.getChangedBy()).append("\n");
        sb.append("  Date: ").append(this.getDate()).append("\n");
        sb.append("  Essential: ").append(this.isEssential()).append("\n");
        sb.append("  Distribution: ").append(this.getDistribution()).append("\n");
        sb.append("  Installed-Size: ").append(this.getInstalledSize()).append("\n");
        sb.append("  Maintainer: ").append(this.getMaintainer()).append("\n");
        sb.append("  Priority: ").append(this.getPriority()).append("\n");
        sb.append("  Section: ").append(this.getSection()).append("\n");
        sb.append("  MD5sum: ").append(this.getMD5sum()).append("\n");
        sb.append("  Description: \n").append(this.getDescription()).append("\n\n");
        sb.append("  Dependencies:\n");
        sb.append("    Depends: ").append(this.getDepends()).append("\n");
        sb.append("    Conflicts: ").append(this.getConflicts()).append("\n");
        sb.append("    Enhances: ").append(this.getEnhances()).append("\n");
        sb.append("    Pre-Depends: ").append(this.getPreDepends()).append("\n");
        sb.append("    Provides: ").append(this.getProvides()).append("\n");
        sb.append("    Recommends: ").append(this.getRecommends()).append("\n");
        sb.append("    Replaces: ").append(this.getReplaces()).append("\n");
        return sb.toString();
    }

    public String forConflictsToString() {
        StringBuilder sb = new StringBuilder();
        sb.append("  Package: ").append(this.getName()).append("\n");
        sb.append("  Version: ").append(this.getVersion()).append("\n");
        sb.append("  Conflicts: ").append(this.getConflicts()).append("\n");
        sb.append("  Provides: ").append(this.getProvides()).append("\n");
        sb.append("  Replaces: ").append(this.getReplaces()).append("\n");
        sb.append("  Description: \n").append(this.getDescription());
        return sb.toString();
    }

    public String toStringWithNameAndVersion() {
        StringBuilder sb = new StringBuilder();
        sb.append("Package: ").append(this.getName()).append(" ").append(this.getVersion());
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.architecture == null ? 0 : this.architecture.hashCode());
        result = 31 * result + (this.changedBy == null ? 0 : this.changedBy.hashCode());
        result = 31 * result + (this.conflicts == null ? 0 : this.conflicts.hashCode());
        result = 31 * result + (this.date == null ? 0 : this.date.hashCode());
        result = 31 * result + (this.depends == null ? 0 : this.depends.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.distribution == null ? 0 : this.distribution.hashCode());
        result = 31 * result + (this.enhances == null ? 0 : this.enhances.hashCode());
        result = 31 * result + (this.essential ? 1231 : 1237);
        result = 31 * result + (this.filename == null ? 0 : this.filename.hashCode());
        result = 31 * result + (this.license == null ? 0 : this.license.hashCode());
        result = 31 * result + (this.maintainer == null ? 0 : this.maintainer.hashCode());
        result = 31 * result + (this.md5sum == null ? 0 : this.md5sum.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.preDepends == null ? 0 : this.preDepends.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.provides == null ? 0 : this.provides.hashCode());
        result = 31 * result + (this.recommends == null ? 0 : this.recommends.hashCode());
        result = 31 * result + (this.replaces == null ? 0 : this.replaces.hashCode());
        result = 31 * result + (this.section == null ? 0 : this.section.hashCode());
        result = 31 * result + (this.shortDescription == null ? 0 : this.shortDescription.hashCode());
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Package other = (Package)obj;
        if (this.architecture == null ? other.architecture != null : !this.architecture.equals(other.architecture)) {
            return false;
        }
        if (this.changedBy == null ? other.changedBy != null : !this.changedBy.equals(other.changedBy)) {
            return false;
        }
        if (this.conflicts == null ? other.conflicts != null : !this.conflicts.equals(other.conflicts)) {
            return false;
        }
        if (this.date == null ? other.date != null : !this.date.equals(other.date)) {
            return false;
        }
        if (this.depends == null ? other.depends != null : !this.depends.equals(other.depends)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.distribution == null ? other.distribution != null : !this.distribution.equals(other.distribution)) {
            return false;
        }
        if (this.enhances == null ? other.enhances != null : !this.enhances.equals(other.enhances)) {
            return false;
        }
        if (this.essential != other.essential) {
            return false;
        }
        if (this.filename == null ? other.filename != null : !this.filename.equals(other.filename)) {
            return false;
        }
        if (this.license == null ? other.license != null : !this.license.equals(other.license)) {
            return false;
        }
        if (this.maintainer == null ? other.maintainer != null : !this.maintainer.equals(other.maintainer)) {
            return false;
        }
        if (this.md5sum == null ? other.md5sum != null : !this.md5sum.equals(other.md5sum)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.preDepends == null ? other.preDepends != null : !this.preDepends.equals(other.preDepends)) {
            return false;
        }
        if (this.priority == null ? other.priority != null : !this.priority.equals(other.priority)) {
            return false;
        }
        if (this.provides == null ? other.provides != null : !this.provides.equals(other.provides)) {
            return false;
        }
        if (this.recommends == null ? other.recommends != null : !this.recommends.equals(other.recommends)) {
            return false;
        }
        if (this.replaces == null ? other.replaces != null : !this.replaces.equals(other.replaces)) {
            return false;
        }
        if (this.section == null ? other.section != null : !this.section.equals(other.section)) {
            return false;
        }
        if (this.shortDescription == null ? other.shortDescription != null : !this.shortDescription.equals(other.shortDescription)) {
            return false;
        }
        if (this.size != other.size) {
            return false;
        }
        if (this.source == null ? other.source != null : !this.source.equals(other.source)) {
            return false;
        }
        if (this.version == null) {
            return other.version == null;
        }
        return this.version.equals(other.version);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMD5sum() {
        return this.md5sum;
    }

    public void setMD5sum(String md5sum) {
        this.md5sum = md5sum;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getInstalledSize() {
        return this.installedSize;
    }

    public void setInstalledSize(long installedSize) {
        this.installedSize = installedSize;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getSection() {
        return this.section;
    }

    public void setSection(String section) {
        this.section = section;
    }

    public String getPriority() {
        return this.priority;
    }

    public void setPriority(String priority) {
        this.priority = priority;
    }

    public String getMaintainer() {
        return this.maintainer;
    }

    public void setMaintainer(String maintainer) {
        this.maintainer = maintainer;
    }

    public boolean isEssential() {
        return this.essential;
    }

    public void setEssential(boolean essential) {
        this.essential = essential;
    }

    public String getDistribution() {
        return this.distribution;
    }

    public void setDistribution(String distribution) {
        this.distribution = distribution;
    }

    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public String getChangedBy() {
        return this.changedBy;
    }

    public void setChangedBy(String changedBy) {
        this.changedBy = changedBy;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public PackageReferenceList getEnhances() {
        return this.enhances;
    }

    public void setEnhances(PackageReferenceList enhances) {
        this.enhances = enhances;
    }

    public PackageReferenceList getRecommends() {
        return this.recommends;
    }

    public void setRecommends(PackageReferenceList recommends) {
        this.recommends = recommends;
    }

    public PackageReferenceList getReplaces() {
        return this.replaces;
    }

    public void setReplaces(PackageReferenceList replaces) {
        this.replaces = replaces;
    }

    @Override
    public int compareTo(Package o) {
        int c1 = this.getName().compareTo(o.getName());
        return c1 == 0 ? this.getVersion().compareTo(o.getVersion()) : c1;
    }

    public boolean isInstalled() {
        return this.installed;
    }

    public void setInstalled(boolean installed) {
        this.installed = installed;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public String getChangeLog() {
        return this.changeLog;
    }

    public void setChangeLog(String changeLog) {
        this.changeLog = changeLog;
    }

    public void updateFrom(Package pkg) {
        this.setArchitecture(pkg.getArchitecture());
        this.setChangedBy(pkg.getChangedBy());
        this.setConflicts(pkg.getConflicts());
        this.setDate(pkg.getDate());
        this.setDepends(pkg.getDepends());
        this.setDescription(pkg.getDescription());
        this.setDistribution(pkg.getDistribution());
        this.setEnhances(pkg.getEnhances());
        this.setEssential(pkg.isEssential());
        this.setFilename(pkg.getFilename());
        this.setLicense(pkg.getLicense());
        this.setMaintainer(pkg.getMaintainer());
        this.setMD5sum(pkg.getMD5sum());
        this.setName(pkg.getName());
        this.setPreDepends(pkg.getPreDepends());
        this.setPriority(pkg.getPriority());
        this.setProvides(pkg.getProvides());
        this.setRecommends(pkg.getRecommends());
        this.setReplaces(pkg.getReplaces());
        this.setSection(pkg.getSection());
        this.setShortDescription(pkg.getShortDescription());
        this.setSize(pkg.getSize());
        this.setSource(pkg.getSource());
        this.setVersion(pkg.getVersion());
        this.setChangeLog(pkg.getChangeLog());
    }
}

