/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openthinclient.manager.util.http.DownloadManager;
import org.openthinclient.pkgmgr.PackageManagerConfiguration;
import org.openthinclient.pkgmgr.db.Installation;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageManagerDatabase;
import org.openthinclient.pkgmgr.exception.PackageManagerDownloadException;
import org.openthinclient.pkgmgr.op.DefaultPackageOperationContext;
import org.openthinclient.pkgmgr.op.InstallPlan;
import org.openthinclient.pkgmgr.op.InstallPlanStep;
import org.openthinclient.pkgmgr.op.PackageManagerOperationReport;
import org.openthinclient.pkgmgr.op.PackageOperation;
import org.openthinclient.pkgmgr.op.PackageOperationDownload;
import org.openthinclient.pkgmgr.op.PackageOperationInstall;
import org.openthinclient.pkgmgr.op.PackageOperationUninstall;
import org.openthinclient.progress.ProgressReceiver;
import org.openthinclient.progress.ProgressTask;
import org.openthinclient.util.dpkg.LocalPackageRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageManagerOperationTask
implements ProgressTask<PackageManagerOperationReport> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PackageManagerOperationTask.class);
    private final PackageManagerConfiguration configuration;
    private final InstallPlan installPlan;
    private final PackageManagerDatabase packageManagerDatabase;
    private final LocalPackageRepository localPackageRepository;
    private final DownloadManager downloadManager;

    public PackageManagerOperationTask(PackageManagerConfiguration configuration, InstallPlan installPlan, PackageManagerDatabase packageManagerDatabase, LocalPackageRepository localPackageRepository, DownloadManager downloadManager) {
        this.configuration = configuration;
        this.installPlan = installPlan;
        this.packageManagerDatabase = packageManagerDatabase;
        this.localPackageRepository = localPackageRepository;
        this.downloadManager = downloadManager;
    }

    public PackageManagerOperationReport execute(ProgressReceiver progressReceiver) throws PackageManagerDownloadException {
        LOGGER.info("Package installation/uninstallation started.");
        Installation installation = new Installation();
        installation.setStart(LocalDateTime.now());
        installation = (Installation)this.packageManagerDatabase.getInstallationRepository().save(installation);
        LOGGER.info("Determining packages to be downloaded");
        progressReceiver.progress("Determining packages to be downloaded");
        Path installDir = this.configuration.getInstallDir().toPath();
        LOGGER.info("Operation destination directory: {}", (Object)installDir);
        this.downloadPackages(installation, installDir, progressReceiver.subprogress(0.0, 0.85));
        PackageManagerOperationReport report = this.executeSteps(installation, installDir, this.installPlan.getSteps(), progressReceiver.subprogress(0.85, 1.0));
        installation.setEnd(LocalDateTime.now());
        this.packageManagerDatabase.getInstallationRepository().save(installation);
        LOGGER.info("Package installation/uninstallation completed.");
        return report;
    }

    private PackageManagerOperationReport executeSteps(Installation installation, Path installDir, List<InstallPlanStep> steps, ProgressReceiver progressReceiver) {
        ArrayList<PackageOperation> operations = new ArrayList<PackageOperation>(steps.size());
        for (InstallPlanStep step : steps) {
            if (step instanceof InstallPlanStep.PackageInstallStep) {
                operations.add(new PackageOperationInstall(((InstallPlanStep.PackageInstallStep)step).getPackage()));
                continue;
            }
            if (step instanceof InstallPlanStep.PackageUninstallStep) {
                operations.add(new PackageOperationUninstall(((InstallPlanStep.PackageUninstallStep)step).getInstalledPackage()));
                continue;
            }
            if (step instanceof InstallPlanStep.PackageVersionChangeStep) {
                operations.add(new PackageOperationUninstall(((InstallPlanStep.PackageVersionChangeStep)step).getInstalledPackage()));
                operations.add(new PackageOperationInstall(((InstallPlanStep.PackageVersionChangeStep)step).getTargetPackage()));
                continue;
            }
            throw new IllegalArgumentException("Unsupported type of install plan step " + step);
        }
        return this.execute(installation, installDir, operations, progressReceiver);
    }

    private void downloadPackages(Installation installation, Path targetDirectory, ProgressReceiver progressReceiver) {
        List operations = Stream.concat(this.installPlan.getPackageInstallSteps().map(InstallPlanStep.PackageInstallStep::getPackage), this.installPlan.getPackageVersionChangeSteps().map(InstallPlanStep.PackageVersionChangeStep::getTargetPackage)).filter(pkg -> !this.localPackageRepository.isAvailable((Package)pkg)).map(pkg -> new PackageOperationDownload((Package)pkg, this.downloadManager)).collect(Collectors.toList());
        this.execute(installation, targetDirectory, operations, progressReceiver);
    }

    private PackageManagerOperationReport execute(Installation installation, Path targetDirectory, List<? extends PackageOperation> operations, ProgressReceiver progressReceiver) {
        PackageManagerOperationReport report = new PackageManagerOperationReport();
        double operationCount = operations.size();
        double step = 1.0 / operationCount;
        for (int i = 0; i < operations.size(); ++i) {
            PackageOperation operation = operations.get(i);
            try {
                report.addPackageReport(this.execute(installation, targetDirectory, operation, progressReceiver.subprogress((double)i * step, (double)i * step + step)));
                continue;
            }
            catch (IOException exception) {
                LOGGER.error("Failed to execute PackageOperation: " + operation, (Throwable)exception);
                report.addPackageReport(new PackageManagerOperationReport.PackageReport(operation.getPackage(), PackageManagerOperationReport.PackageReportType.FAIL));
            }
        }
        return report;
    }

    private PackageManagerOperationReport.PackageReport execute(Installation installation, Path targetDirectory, PackageOperation operation, ProgressReceiver progressReceiver) throws IOException {
        DefaultPackageOperationContext context = new DefaultPackageOperationContext(this.localPackageRepository, this.packageManagerDatabase, installation, targetDirectory, operation.getPackage());
        operation.execute(context, progressReceiver);
        this.packageManagerDatabase.getInstallationLogEntryRepository().save(context.getLog());
        PackageManagerOperationReport.PackageReportType reportType = null;
        if (operation instanceof PackageOperationInstall) {
            reportType = PackageManagerOperationReport.PackageReportType.INSTALL;
        } else if (operation instanceof PackageOperationUninstall) {
            reportType = PackageManagerOperationReport.PackageReportType.UNINSTALL;
        } else if (operation instanceof PackageOperationDownload) {
            reportType = PackageManagerOperationReport.PackageReportType.DOWNLOAD;
        }
        return new PackageManagerOperationReport.PackageReport(operation.getPackage(), reportType);
    }

    public ProgressTask.ProgressTaskDescription getDescription(Locale locale) {
        return null;
    }
}

