/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.ar.ArArchiveEntry;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.io.IOUtils;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.op.PackageOperation;
import org.openthinclient.pkgmgr.op.PackageOperationContext;
import org.openthinclient.pkgmgr.op.PackageOperationDownload;
import org.openthinclient.progress.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageOperationInstall
implements PackageOperation {
    private static final Logger LOG = LoggerFactory.getLogger(PackageOperationInstall.class);
    private final Package pkg;

    public PackageOperationInstall(Package pkg) {
        this.pkg = pkg;
    }

    private int findAREntry(String segmentName, Path localPackageFile, EntryCallback callback) throws IOException {
        ArArchiveEntry e;
        ArArchiveInputStream ais = new ArArchiveInputStream(Files.newInputStream(localPackageFile, new OpenOption[0]));
        int callbackCount = 0;
        while ((e = ais.getNextArEntry()) != null) {
            if (!e.getName().equals(segmentName)) continue;
            callback.handleEntry(e.getName(), (InputStream)ais);
            ++callbackCount;
        }
        ais.close();
        return callbackCount;
    }

    @Override
    public Package getPackage() {
        return this.pkg;
    }

    @Override
    public void execute(PackageOperationContext context, ProgressReceiver progressReceiver) throws IOException {
        progressReceiver.progress("Installing package '" + this.pkg.getName() + "'");
        Path localPackageFile = context.getLocalPackageRepository().getPackage(this.pkg);
        if (this.findAREntry("data.tar.gz", localPackageFile, (entry, ais) -> {
            TarArchiveEntry t;
            TarArchiveInputStream tis = new TarArchiveInputStream((InputStream)new GZIPInputStream(ais));
            ArrayList<PackageInstalledContent> installedContents = new ArrayList<PackageInstalledContent>();
            while ((t = tis.getNextTarEntry()) != null) {
                PackageInstalledContent installedContent = this.installFile(tis, t, context);
                if (installedContent == null) continue;
                installedContents.add(installedContent);
            }
            int sequenceNumber = 0;
            for (PackageInstalledContent e : installedContents) {
                e.setPackage(this.pkg);
                e.setSequence(sequenceNumber++);
            }
            this.pkg.setInstalled(true);
            context.getDatabase().getPackageRepository().save(this.pkg);
            context.getDatabase().getInstalledContentRepository().save(installedContents);
        }) == 0) {
            throw new IOException("Illegal package format. Missing data.tar.gz");
        }
    }

    private PackageInstalledContent installFile(TarArchiveInputStream tis, TarArchiveEntry t, PackageOperationContext context) throws IOException {
        if (t.isDirectory() && t.getName().equals("./")) {
            return null;
        }
        String name = t.getName().startsWith("./") ? t.getName().substring(2) : t.getName();
        Path relativePath = Paths.get(name, new String[0]);
        if (System.getProperty("os.name").toUpperCase().contains("WINDOWS") && t.getFile() != null && t.getFile().getPath() != null && t.getFile().getPath().contains("::")) {
            throw new IOException();
        }
        PackageInstalledContent installedContent = new PackageInstalledContent();
        installedContent.setPath(relativePath);
        if (t.isFile()) {
            String sha1;
            try (OutputStream os = context.createFile(relativePath);
                 DigestOutputStream digestOut = new DigestOutputStream(os, this.getSha1MessageDigest());){
                IOUtils.copy((InputStream)tis, (OutputStream)digestOut);
                sha1 = PackageOperationDownload.byteArrayToHexString(digestOut.getMessageDigest().digest()).toLowerCase();
            }
            installedContent.setType(PackageInstalledContent.Type.FILE);
            installedContent.setSha1(sha1);
        } else if (t.isDirectory()) {
            context.createDirectory(relativePath);
            installedContent.setType(PackageInstalledContent.Type.DIR);
        } else if (t.isLink() || t.isSymbolicLink()) {
            context.createSymlink(relativePath, Paths.get(t.getLinkName(), new String[0]));
            installedContent.setType(PackageInstalledContent.Type.SYMLINK);
        } else {
            LOG.error("Unsupported type of TAR content: " + t.getName());
            return null;
        }
        return installedContent;
    }

    private MessageDigest getSha1MessageDigest() {
        try {
            return MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing SHA1 message digest implementation", e);
        }
    }

    private static interface EntryCallback {
        public void handleEntry(String var1, InputStream var2) throws IOException;
    }
}

