/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.pkgmgr.op;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.stream.Stream;
import org.openthinclient.pkgmgr.db.Package;
import org.openthinclient.pkgmgr.db.PackageInstalledContent;
import org.openthinclient.pkgmgr.op.PackageOperation;
import org.openthinclient.pkgmgr.op.PackageOperationContext;
import org.openthinclient.pkgmgr.op.PackageOperationDownload;
import org.openthinclient.progress.ProgressReceiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageOperationUninstall
implements PackageOperation {
    private static final Logger LOG = LoggerFactory.getLogger(PackageOperationUninstall.class);
    private final Package pkgToUninstall;

    public PackageOperationUninstall(Package pkgToUninstall) {
        this.pkgToUninstall = pkgToUninstall;
    }

    @Override
    public Package getPackage() {
        return this.pkgToUninstall;
    }

    @Override
    public void execute(PackageOperationContext context, ProgressReceiver progressReceiver) throws IOException {
        progressReceiver.progress("Uninstalling package '" + this.pkgToUninstall.getName() + "'");
        List<PackageInstalledContent> contents = context.getDatabase().getInstalledContentRepository().findByPkgOrderBySequenceDesc(this.pkgToUninstall);
        LOG.info("Uninstalling package {} {}", (Object)this.pkgToUninstall.getName(), (Object)this.pkgToUninstall.getVersion());
        for (PackageInstalledContent content : contents) {
            switch (content.getType()) {
                case FILE: {
                    this.deleteFile(context, content);
                    break;
                }
                case DIR: {
                    this.deleteDirectory(context, content);
                    break;
                }
                case SYMLINK: {
                    context.delete(content.getPath());
                }
            }
        }
        context.getDatabase().getInstalledContentRepository().delete(contents);
        this.pkgToUninstall.setInstalled(false);
        context.getDatabase().getPackageRepository().save(this.pkgToUninstall);
    }

    private void deleteDirectory(PackageOperationContext context, PackageInstalledContent content) throws IOException {
        boolean empty;
        try (Stream<Path> children = context.list(content.getPath());){
            empty = children.count() == 0L;
        }
        catch (NoSuchFileException exception) {
            LOG.warn("Skipping not existing directory (marked for delete): {}", (Object)content.getPath());
            return;
        }
        if (empty) {
            LOG.info("Deleting empty directory {}", (Object)content.getPath());
            context.delete(content.getPath());
        } else {
            LOG.info("Skipping non empty directory {}", (Object)content.getPath());
        }
    }

    private void deleteFile(PackageOperationContext context, PackageInstalledContent content) throws IOException {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Missing SHA1 digest algorithm", e);
        }
        if (context.isRegularFile(content.getPath())) {
            try (InputStream in = context.newInputStream(content.getPath());){
                int read;
                byte[] bytes = new byte[10240];
                while ((read = in.read(bytes)) != -1) {
                    md.update(bytes, 0, read);
                }
            }
            byte[] digest = md.digest();
            String d = PackageOperationDownload.byteArrayToHexString(digest);
            if (d.equalsIgnoreCase(content.getSha1())) {
                LOG.info("Deleting unmodified file {}", (Object)content.getPath());
                context.delete(content.getPath());
            } else {
                LOG.warn("Not deleting modified file {}", (Object)content.getPath());
            }
        } else {
            LOG.warn("Previously installed file could not be found {}", (Object)content.getPath());
        }
    }
}

