/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.util.Assert;
import org.springframework.validation.AbstractPropertyBindingResult;

public class ValidationErrors
extends AbstractPropertyBindingResult {
    private static final long serialVersionUID = 8141826537389141361L;
    private final Object source;
    private final PersistentEntities entities;

    public ValidationErrors(Object source, PersistentEntities entities) {
        super(source.getClass().getSimpleName());
        Assert.notNull((Object)source, (String)"Entity must not be null!");
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        this.entities = entities;
        this.source = source;
    }

    public ConfigurablePropertyAccessor getPropertyAccessor() {
        return new DirectFieldAccessor(this.getTarget()){

            public Object getPropertyValue(String propertyName) throws BeansException {
                List<String> segments = Arrays.asList(propertyName.split("\\."));
                Iterator iterator = segments.iterator();
                Object value = ValidationErrors.this.source;
                do {
                    String segment = (String)iterator.next();
                    PersistentEntity entity = ValidationErrors.this.entities.getPersistentEntity(value.getClass());
                    PersistentProperty property = entity.getPersistentProperty(PropertyAccessorUtils.getPropertyName((String)segment));
                    if (property == null) {
                        throw new NotReadablePropertyException(ValidationErrors.this.source.getClass(), propertyName);
                    }
                    BeanWrapper accessor = property.usePropertyAccess() ? PropertyAccessorFactory.forBeanPropertyAccess((Object)value) : PropertyAccessorFactory.forDirectFieldAccess((Object)value);
                    value = accessor.getPropertyValue(segment);
                } while (iterator.hasNext());
                return value;
            }
        };
    }

    public Object getTarget() {
        return this.source;
    }
}

