/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.syslogd;

import com.levigo.util.collections.IntHashtable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.text.ParseException;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openthinclient.syslogd.TimestampFormat;

public abstract class SyslogDaemon
implements Runnable {
    private static final int IN_BUF_SZ = 8192;
    public static final int SYSLOG_PORT = 514;
    private final int port;
    private final DatagramSocket socket;
    private boolean shutdownRequested;

    public SyslogDaemon() throws SocketException {
        this(514);
    }

    public SyslogDaemon(int port) throws SocketException {
        this.port = port;
        this.socket = new DatagramSocket(this.port);
    }

    public void finalize() {
        this.shutdown();
    }

    public void shutdown() {
        this.shutdownRequested = true;
        if (null != this.socket && !this.socket.isClosed()) {
            this.socket.close();
        }
    }

    @Override
    public void run() {
        byte[] buffer = new byte[8192];
        DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
        while (!this.shutdownRequested) {
            try {
                this.socket.receive(packet);
            }
            catch (IOException e) {
                this.handleError("Error receiving message: ", e);
                break;
            }
            try {
                this.processMessage(packet);
            }
            catch (Exception e) {
                this.handleError("Exception processing message: ", e);
            }
        }
    }

    public void processMessage(DatagramPacket packet) {
        block13: {
            try {
                String message = new String(packet.getData(), 0, packet.getLength(), "UTF-8");
                try {
                    Pattern messagePattern = Pattern.compile("^<(\\d{1,3})>(\\p{ASCII}{3} \\d{2} \\d{2}:\\d{2}:\\d{2})\\s+(\\p{XDigit}{2}:\\p{XDigit}{2}:\\p{XDigit}{2}:\\p{XDigit}{2}:\\p{XDigit}{2}:\\p{XDigit}{2})\\s*(.*)$");
                    Matcher m = messagePattern.matcher(message);
                    if (m.matches()) {
                        Facility facility;
                        Priority priority;
                        String priStr = m.group(1);
                        if (priStr.length() == 0) {
                            priority = Priority.LOG_INFO;
                            facility = Facility.LOG_USER;
                        } else {
                            try {
                                int code = Integer.parseInt(priStr);
                                priority = Priority.fromCode(code);
                                if (null == priority) {
                                    this.handleError("No Priority for code " + Priority.getCode(code), null);
                                    priority = Priority.LOG_INFO;
                                }
                                if (null == (facility = Facility.fromCode(code))) {
                                    this.handleError("No Facility for code " + Facility.getCode(code), null);
                                    facility = Facility.LOG_USER;
                                }
                            }
                            catch (NumberFormatException e) {
                                priority = Priority.LOG_INFO;
                                facility = Facility.LOG_USER;
                            }
                        }
                        Date timestamp = new Date();
                        try {
                            timestamp = TimestampFormat.getInstance().parse(m.group(2));
                        }
                        catch (ParseException e) {
                            this.handleError("Can't parse timestamp " + message.substring(0, 15), null);
                            timestamp = new Date();
                        }
                        this.handleMessage(packet.getAddress(), m.group(3), priority, facility, timestamp, m.group(4));
                        break block13;
                    }
                    this.handleMessage(packet.getAddress(), null, Priority.LOG_INFO, Facility.LOG_USER, new Date(), message);
                }
                catch (Throwable t) {
                    this.handleError("Can't parse message: " + message, t);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    protected abstract void handleError(String var1, Throwable var2);

    protected abstract void handleMessage(InetAddress var1, String var2, Priority var3, Facility var4, Date var5, String var6);

    public static enum Priority {
        LOG_EMERG(0, "emergency"),
        LOG_ALERT(1, "alert"),
        LOG_CRIT(2, "critical"),
        LOG_ERR(3, "error"),
        LOG_WARNING(4, "warning"),
        LOG_NOTICE(5, "notice"),
        LOG_INFO(6, "info"),
        LOG_DEBUG(7, "debug"),
        LOG_ALL(8, "all");

        private static IntHashtable byValue;
        private final String fullName;
        private final int code;
        private static final int LOG_PRIMASK = 7;

        private Priority(int code, String name) {
            this.code = code;
            this.fullName = name;
        }

        public String getFullName() {
            return this.fullName;
        }

        public static Priority fromCode(int code) {
            if (null == byValue) {
                byValue = new IntHashtable();
                for (Priority p : Priority.values()) {
                    byValue.put(p.code, (Object)p);
                }
            }
            return (Priority)((Object)byValue.get(Priority.getCode(code)));
        }

        public static int getCode(int code) {
            return code & 7;
        }
    }

    public static enum Facility {
        LOG_KERN(0, "kernel"),
        LOG_USER(1, "user"),
        LOG_MAIL(2, "mail"),
        LOG_DAEMON(3, "daemon"),
        LOG_AUTH(4, "authentication"),
        LOG_SYSLOG(5, "syslog"),
        LOG_LPR(6, "lpr"),
        LOG_NEWS(7, "news"),
        LOG_UUCP(8, "uucp"),
        LOG_CRON(9, "cron"),
        LOG_LOCAL0(16, "local0"),
        LOG_LOCAL1(17, "local1"),
        LOG_LOCAL2(18, "local2"),
        LOG_LOCAL3(19, "local3"),
        LOG_LOCAL4(20, "local4"),
        LOG_LOCAL5(21, "local5"),
        LOG_LOCAL6(22, "local6"),
        LOG_LOCAL7(23, "local7");

        private static IntHashtable byValue;
        private final int code;
        private final String fullName;
        private static final int LOG_FACMASK = 1016;

        private Facility(int code, String fullName) {
            this.code = code;
            this.fullName = fullName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public static Facility fromCode(int code) {
            if (null == byValue) {
                byValue = new IntHashtable();
                for (Facility f : Facility.values()) {
                    byValue.put(f.code, (Object)f);
                }
            }
            return (Facility)((Object)byValue.get(Facility.getCode(code)));
        }

        public static int getCode(int code) {
            return (code & 0x3F8) >> 3;
        }
    }
}

