/*
 * Decompiled with CFR 0.152.
 */
package org.openthinclient.runtime.control;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.ParserProperties;
import org.openthinclient.runtime.control.cmd.AbstractCommand;
import org.openthinclient.runtime.control.cmd.ListDistributionsCommand;
import org.openthinclient.runtime.control.cmd.PrepareHomeCommand;
import org.openthinclient.runtime.control.cmd.RemoveServerIdCommand;
import org.openthinclient.runtime.control.cmd.ShowVersionCommand;

public class ManagerControlApplication {
    public static final AbstractCommand<?>[] COMMANDS = new AbstractCommand[]{new PrepareHomeCommand(), new ListDistributionsCommand(), new RemoveServerIdCommand(), new ShowVersionCommand()};

    public static void main(String[] args) {
        Optional<AbstractCommand<?>> commandOptional;
        if (args.length == 0) {
            ManagerControlApplication.printHelp();
            System.exit(1);
        }
        if (!(commandOptional = ManagerControlApplication.determineCommand(args[0])).isPresent()) {
            ManagerControlApplication.printErrorHelp(args);
            System.exit(1);
            return;
        }
        AbstractCommand<?> command = commandOptional.get();
        String[] commandArgs = new String[args.length - 1];
        if (commandArgs.length > 0) {
            System.arraycopy(args, 1, commandArgs, 0, commandArgs.length);
        }
        try {
            Object optionsObject = command.createOptionsObject();
            CmdLineParser parser = new CmdLineParser(optionsObject);
            parser.parseArgument(commandArgs);
            command.execute(optionsObject);
            System.exit(0);
        }
        catch (CmdLineException e) {
            System.err.println(e.getLocalizedMessage());
            System.err.println("");
            ManagerControlApplication.printErrorHelp();
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("#####");
            System.err.println("## Execution Failed");
            System.err.println("## " + e.getMessage() + " (" + e.getClass().getName() + ")");
            System.err.println("#####");
        }
        System.exit(1);
    }

    private static Optional<AbstractCommand<?>> determineCommand(String arg) {
        return Stream.of(COMMANDS).filter(cmd -> cmd.getName().equals(arg)).findFirst();
    }

    private static void printErrorHelp() {
        ManagerControlApplication.printHelp(System.err);
    }

    private static void printErrorHelp(String[] args) {
        System.err.println("Unsupported command line: " + Stream.of(args).collect(Collectors.joining(" ")));
        ManagerControlApplication.printErrorHelp();
    }

    private static void printHelp() {
        ManagerControlApplication.printHelp(System.out);
    }

    private static void printHelp(PrintStream ps) {
        ps.println("Usage:");
        Integer maxLength = Stream.of(COMMANDS).map(cmd -> cmd.getName().length()).max(Integer::compareTo).get();
        ParserProperties properties = ParserProperties.defaults().withUsageWidth(78 - maxLength);
        for (AbstractCommand<?> cmd2 : COMMANDS) {
            ps.println();
            ps.println(cmd2.getName() + ":");
            CmdLineParser parser = new CmdLineParser(cmd2.createOptionsObject(), properties);
            parser.printUsage((OutputStream)ps);
        }
        ps.flush();
    }
}

