/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

public class ExtractFilter
extends ImageFilter {
    private Rectangle extractionArea;

    public ExtractFilter(Rectangle extractionArea) {
        this.extractionArea = extractionArea;
    }

    public void setDimensions(int width, int height) {
        this.extractionArea = this.extractionArea.intersection(new Rectangle(0, 0, width, height));
        this.consumer.setDimensions(this.extractionArea.width, this.extractionArea.height);
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        int x1 = Math.max(x, this.extractionArea.x);
        int x2 = Math.min(x + w, this.extractionArea.x + this.extractionArea.width);
        int y1 = Math.max(y, this.extractionArea.y);
        int y2 = Math.min(y + h, this.extractionArea.y + this.extractionArea.height);
        int width = x2 - x1;
        int height = y2 - y1;
        if (width < 0 || height < 0) {
            return;
        }
        int dx = x1 - this.extractionArea.x;
        int dy = y1 - this.extractionArea.y;
        if (width == w) {
            if (height == h) {
                this.consumer.setPixels(dx, dy, w, h, model, pixels, off, scansize);
            } else {
                this.consumer.setPixels(dx, dy, width, height, model, pixels, off + scansize * (y1 - y), scansize);
            }
            return;
        }
        int scanOffset = off + (x1 - x) + scansize * (y1 - y);
        for (int i = 0; i < height; ++i) {
            this.consumer.setPixels(dx, dy + i, width, 1, model, pixels, scanOffset, width);
            scanOffset += scansize;
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
        int x1 = Math.max(x, this.extractionArea.x);
        int x2 = Math.min(x + w, this.extractionArea.x + this.extractionArea.width);
        int y1 = Math.max(y, this.extractionArea.y);
        int y2 = Math.min(y + h, this.extractionArea.y + this.extractionArea.height);
        int width = x2 - x1;
        int height = y2 - y1;
        if (width < 0 || height < 0) {
            return;
        }
        int dx = x1 - this.extractionArea.x;
        int dy = y1 - this.extractionArea.y;
        if (width == w) {
            if (height == h) {
                this.consumer.setPixels(dx, dy, w, h, model, pixels, off, scansize);
            } else {
                this.consumer.setPixels(dx, dy, width, height, model, pixels, off + scansize * (y1 - y), scansize);
            }
            return;
        }
        int scanOffset = off + (x1 - x) + scansize * (y1 - y);
        for (int i = 0; i < height; ++i) {
            this.consumer.setPixels(dx, dy + i, width, 1, model, pixels, scanOffset, width);
            scanOffset += scansize;
        }
    }
}

