/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.image;

import com.levigo.util.image.PixelUtils;
import java.awt.image.RGBImageFilter;

public class GrayFilter
extends RGBImageFilter {
    private int percent = 100;

    public GrayFilter(int percent) {
        this.percent = percent;
    }

    public int filterRGB(int x, int y, int rgb) {
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        int gray = (int)((0.3 * (double)r + 0.59 * (double)g + 0.11 * (double)b) / 3.0);
        if (this.percent != 100) {
            gray = gray * this.percent / 100;
            r = gray + r * (100 - this.percent) / 100;
            g = gray + g * (100 - this.percent) / 100;
            b = gray + b * (100 - this.percent) / 100;
        } else {
            b = g = gray;
            r = g;
        }
        gray = PixelUtils.clamp(gray);
        return a << 24 | r << 16 | g << 8 | b << 0;
    }
}

