/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.image;

import java.awt.image.RGBImageFilter;

public abstract class TransferFilter
extends RGBImageFilter {
    protected boolean initialized = false;
    protected int[] aTable;
    protected int[] rTable;
    protected int[] gTable;
    protected int[] bTable;
    protected static int[] identityTable = new int[256];

    public TransferFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        if (!this.initialized) {
            this.initialize();
            this.initialized = true;
        }
        int a = rgb >> 24 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        a = this.aTable[a];
        r = this.rTable[r];
        g = this.gTable[g];
        b = this.bTable[b];
        return a << 24 | r << 16 | g << 8 | b;
    }

    public void setDimensions(int width, int height) {
        this.initialized = false;
        super.setDimensions(width, height);
    }

    protected void initialize() {
        this.aTable = identityTable;
        this.bTable = this.makeTable();
        this.gTable = this.bTable;
        this.rTable = this.bTable;
    }

    protected int[] makeTable() {
        int[] table = new int[256];
        for (int i = 0; i < 256; ++i) {
            table[i] = this.transferFunction(i);
        }
        return table;
    }

    protected abstract int transferFunction(int var1);

    static {
        for (int i = 0; i < identityTable.length; ++i) {
            TransferFilter.identityTable[i] = i;
        }
    }
}

