/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;

public class Message {
    public static final String DISPLAY = "DISPLAY";
    public static final String CONFIRM = "CONFIRM";
    public static final String CHOICE = "CHOICE";
    public static final String INPUT = "INPUT";
    public static final String HIDDEN_INPUT = "HIDDEN_INPUT";
    public static final String NOTICE = "NOTICE";
    public static final String INFO = "INFO";
    public static final String WARNING = "WARNING";
    public static final String ERROR = "ERROR";
    public static final String NO = "NO";
    public static final String YES = "YES";
    private String identifier = "";
    private String description = "";
    private String type = "DISPLAY";
    private String severity = "INFO";
    private String titleText;
    private String bodyText;
    private String detailsText;
    private String[] controlLabels;
    private String[] controlMnemonics;
    private Throwable exception;
    private boolean isSuppressable;
    private boolean isSuppressed;

    public Message(String id, String type, String severity, String title, String body, String details, Throwable e, String[] controlTexts) {
        this.setType(type);
        this.setSeverity(severity);
        this.setIdentifier(id);
        this.setTitleText(title);
        this.setBodyText(body);
        this.setDetailsText(details);
        this.setException(e);
        if (controlTexts != null && this.controlTextsNotEmpty(controlTexts)) {
            this.setControlLabels(controlTexts);
        } else {
            this.setControlLabels(new String[]{"Ok", "Cancel", null});
        }
    }

    public Message(String id, String type, String severity, String title, String body, String details, String description, Throwable e, String[] controlTexts, boolean isSuppressable, boolean isSuppressed) {
        this(id, type, severity, title, body, details, e, controlTexts);
        this.isSuppressable = isSuppressable;
        this.isSuppressed = isSuppressed;
        this.description = description;
    }

    public Message(String id, String type, String severity, String title, String body, String details, String description, Throwable e, String[] controlTexts, String[] controlMnemonics, boolean isSuppressable, boolean isSuppressed) {
        this(id, type, severity, title, body, details, description, e, controlTexts, isSuppressable, isSuppressed);
        this.controlMnemonics = controlMnemonics;
    }

    public String getBodyText() {
        return this.bodyText;
    }

    public String[] getControlLabels() {
        return this.controlLabels;
    }

    public String[] getControlMnemonics() {
        return this.controlMnemonics;
    }

    public String getDetailsText() {
        if (null != this.exception) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter printWriter = new PrintWriter(baos);
            this.exception.printStackTrace(printWriter);
            printWriter.close();
            return baos.toString();
        }
        return this.detailsText;
    }

    public String getTitleText() {
        return this.titleText;
    }

    public String getDescription() {
        return this.description;
    }

    public void setBodyText(String bodyText) {
        this.bodyText = bodyText;
    }

    public void setControlLabels(String[] controlLabels) {
        this.controlLabels = controlLabels;
    }

    public void setDetailsText(String detailsText) {
        this.detailsText = detailsText;
    }

    public void setTitleText(String titleText) {
        this.titleText = titleText;
    }

    public String getType() {
        return this.type;
    }

    public String getSeverity() {
        return this.severity;
    }

    public void setType(String type) {
        if (type.equals(CHOICE) || type.equals(DISPLAY) || type.equals(CONFIRM) || type.equals(INPUT) || type.equals(HIDDEN_INPUT)) {
            this.type = type;
        }
    }

    public void setSeverity(String severity) {
        if (severity.equals(INFO) || severity.equals(WARNING) || severity.equals(ERROR)) {
            this.severity = severity;
        }
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String messageIdentifier) {
        this.identifier = messageIdentifier;
    }

    private boolean controlTextsNotEmpty(String[] texts) {
        if (null != texts) {
            for (int i = 0; i < texts.length; ++i) {
                if (null == texts[i] || texts[i].equals("")) continue;
                return true;
            }
        }
        return false;
    }

    public void setException(Throwable e) {
        this.exception = e;
    }

    public boolean isSuppressable() {
        return this.isSuppressable;
    }

    public boolean isSuppressed() {
        return this.isSuppressed;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("----- Message (").append(this.type).append(",").append(this.severity).append(this.isSuppressable ? ",NON-" : ",").append("SUPPRESSABLE").append(this.isSuppressed ? ",SUPPRESSED" : "").append(") ").append(this.identifier).append("\nTitle: ").append(this.titleText).append("\n\n").append(this.bodyText).append("\nDetails: >>\n  ").append(this.detailsText).append("\nCaused by: ").append(this.exception).append("\n----\n");
        if (null != this.controlLabels) {
            sb.append("[");
            for (int i = 0; i < this.controlLabels.length; ++i) {
                sb.append(this.controlLabels[i]);
                if (i >= this.controlLabels.length - 1) continue;
                sb.append("|");
            }
            sb.append("]\n");
        }
        return sb.toString();
    }
}

