/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging;

import com.levigo.util.messaging.MessageEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MessageResult {
    public static final String BOOLEAN_DECISION = "BOOLEAN_DECISION";
    public static final String YES_NO_CANCEL_DECISION = "YES_NO_CANCEL_DECISION";
    public static final String YES_AFFIRMED = "YES_AFFIRMED";
    public static final String NO_AFFIRMED = "NO_AFFIRMED";
    public static final String CANCEL_AFFIRMED = "CANCEL_AFFIRMED";
    public static final String STANDARD_INPUT_STRING = "STANDARD_INPUT_STRING";
    private Map results = null;
    private MessageEvent messageEvent = null;

    public MessageResult(MessageEvent associatedMessageEvent) {
        this.setMessageEvent(associatedMessageEvent);
    }

    public void addResult(Object resultIdentifier, Object result) {
        this.getResults().put(resultIdentifier, result);
    }

    public Object get(Object resultIdentifier) {
        return this.getResults().get(resultIdentifier);
    }

    public boolean getBoolean(Object resultIdentifier) {
        Object result = this.getResults().get(resultIdentifier);
        return null != result && result instanceof Boolean && (Boolean)result != false;
    }

    private Map getResults() {
        if (this.results == null) {
            this.results = new HashMap();
        }
        return this.results;
    }

    public boolean containsKey(Object resultIdentifier) {
        return this.getResults().containsKey(resultIdentifier);
    }

    public boolean isEmpty() {
        return this.results == null || this.getResults().isEmpty();
    }

    public Iterator getResultKeys() {
        return this.getResults().keySet().iterator();
    }

    public Object removeResult(Object resultIdentifier) {
        if (this.results == null) {
            return null;
        }
        return this.getResults().remove(resultIdentifier);
    }

    protected void finalize() throws Throwable {
        if (!this.isEmpty()) {
            this.getResults().clear();
        }
        this.results = null;
        this.setMessageEvent(null);
        super.finalize();
    }

    public MessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    private void setMessageEvent(MessageEvent messageEvent) {
        this.messageEvent = messageEvent;
    }

    public String toString() {
        String description = "---- MessageResult:\n";
        if (this.results == null || this.results.isEmpty()) {
            description = description + "no stored results.";
        } else {
            int resultNumber = 1;
            Iterator it = this.getResultKeys();
            while (it.hasNext()) {
                Object key = it.next();
                description = description + "Result #" + resultNumber++ + " Key: " + key + " Value: " + this.get(key) + "\n";
            }
        }
        return description;
    }
}

