/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging.dialog;

import com.levigo.util.messaging.Message;
import com.levigo.util.messaging.MessageEvent;
import com.levigo.util.messaging.MessageListener;
import com.levigo.util.messaging.dialog.DefaultMessageDialog;
import com.levigo.util.messaging.dialog.DefaultTextResources;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class DefaultDialogMessageListener
implements MessageListener {
    private static final JFrame PARENT = new JFrame();
    private static DefaultDialogMessageListener theInstance;
    private Set ignoredMessageTypes = new HashSet();
    private boolean centerOnParent = false;
    private boolean resizable = false;

    private DefaultDialogMessageListener() {
    }

    public static DefaultDialogMessageListener getInstance() {
        if (theInstance == null) {
            theInstance = new DefaultDialogMessageListener();
        }
        return theInstance;
    }

    public void displayMessage(MessageEvent e) {
        Frame parent;
        Message message = e.getMessage();
        if (this.ignoredMessageTypes.contains(message.getType())) {
            return;
        }
        String title = null;
        if (message.getType().equals("DISPLAY") || message.getType().equals("CONFIRM")) {
            title = DefaultTextResources.getString("common.hint");
        } else if (message.getType().equals("CHOICE")) {
            title = DefaultTextResources.getString("common.question");
        } else if (message.getType().equals("INPUT") || message.getType().equals("HIDDEN_INPUT")) {
            title = DefaultTextResources.getString("common.input");
        }
        Component possibleParent = null;
        if (e.getSource() != null && e.getSource() instanceof Component) {
            possibleParent = SwingUtilities.getRoot((Component)e.getSource());
        }
        if (possibleParent != null && possibleParent instanceof Dialog && possibleParent.getParent() != null) {
            possibleParent = possibleParent.getParent();
        }
        Frame frame = parent = possibleParent != null && possibleParent instanceof Frame ? (Frame)possibleParent : PARENT;
        if (parent == PARENT && null != e.getSource()) {
            Window activeWindow = this.getActiveWindow();
            if (null != activeWindow && activeWindow instanceof Frame) {
                parent = (Frame)activeWindow;
            } else {
                System.err.println("Warning, deprecated usage: inappropriate source (" + e.getSource() + ") specified for message [" + e.getMessage().getIdentifier() + "]: " + e.getMessage().getTitleText());
            }
        }
        new DefaultMessageDialog(parent, title, e, this.isCenterOnParent(), this.isResizable()).setVisible(true);
    }

    private Window getActiveWindow() {
        Window window = null;
        boolean available = false;
        try {
            available = Integer.parseInt(System.getProperty("java.version").substring(2, 3)) > 4;
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (available) {
            try {
                Class<?> kfmClass = Class.forName("java.awt.KeyboardFocusManager");
                Method getCurrentKeyboardFocusManager = kfmClass.getDeclaredMethod("getCurrentKeyboardFocusManager", null);
                Object currentKeyboardFocusManager = getCurrentKeyboardFocusManager.invoke(kfmClass, (Object[])null);
                Method getActiveWindowMethod = currentKeyboardFocusManager.getClass().getMethod("getActiveWindow", null);
                window = (Window)getActiveWindowMethod.invoke(currentKeyboardFocusManager, (Object[])null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return window;
    }

    public boolean isCenterOnParent() {
        return this.centerOnParent;
    }

    public void setCenterOnParent(boolean centerOnParent) {
        this.centerOnParent = centerOnParent;
    }

    public void ignore(String messageType) {
        if (messageType.equals("CHOICE") || messageType.equals("DISPLAY") || messageType.equals("CONFIRM") || messageType.equals("INPUT") || messageType.equals("HIDDEN_INPUT")) {
            this.ignoredMessageTypes.add(messageType);
        }
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public void setResizable(boolean resizable) {
        this.resizable = resizable;
    }
}

