/*
 * Decompiled with CFR 0.152.
 */
package com.levigo.util.messaging.dialog;

import com.levigo.util.messaging.MessageManager;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class MessageSuppressionPanel
extends JPanel {
    private static final String TOOLTIP_TEXT = "<html><body><font face=\"Arial, Helvetica, sans-serif\">Um Meldungen anzuzeigen bzw. zu unterdr\u00fccken,<br>gehen Sie folgendermassen vor:<br>- Checkbox aktiviert: Meldung wird angezeigt.<br>- Checkbox deaktiviert: Meldung ist unterdr\u00fcckt.</font></body></html>";
    private Hashtable checkBoxMessageKeyTable;
    private SortedSet checkBoxSortedSet;

    public MessageSuppressionPanel() {
        super(new GridBagLayout());
        this.initGui();
    }

    private void initGui() {
        MessageSuppressionCheckBox checkBox;
        Iterator keyIterator = MessageManager.getSuppressableMessages().iterator();
        this.checkBoxMessageKeyTable = new Hashtable();
        this.checkBoxSortedSet = new TreeSet();
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 1;
        c.anchor = 17;
        c.fill = 0;
        while (keyIterator.hasNext()) {
            String s = (String)keyIterator.next();
            String messageKey = s.substring(0, s.length() - ".isSuppressedMessage".length() - 2);
            checkBox = new MessageSuppressionCheckBox(MessageManager.getMessage(messageKey, null, null).getDescription().equals("") ? messageKey : MessageManager.getMessage(messageKey, null, null).getDescription(), !MessageManager.isMessageSuppressed(messageKey));
            checkBox.addItemListener(new MessageSuppressionItemListener());
            this.checkBoxMessageKeyTable.put(checkBox, messageKey);
            this.checkBoxSortedSet.add(checkBox);
        }
        while (!this.checkBoxSortedSet.isEmpty()) {
            checkBox = (MessageSuppressionCheckBox)this.checkBoxSortedSet.first();
            this.add((Component)checkBox, c);
            this.checkBoxSortedSet.remove(checkBox);
        }
    }

    public void refresh() {
        Enumeration checkBoxes = this.checkBoxMessageKeyTable.keys();
        while (checkBoxes.hasMoreElements()) {
            JCheckBox checkBox = (JCheckBox)checkBoxes.nextElement();
            if (MessageManager.isMessageSuppressed((String)this.checkBoxMessageKeyTable.get(checkBox)) == !checkBox.isSelected()) continue;
            checkBox.setSelected(!MessageManager.isMessageSuppressed((String)this.checkBoxMessageKeyTable.get(checkBox)));
        }
        this.repaint();
    }

    private class MessageSuppressionCheckBox
    extends JCheckBox
    implements Comparable {
        private String description;

        public MessageSuppressionCheckBox(String text, boolean selected) {
            super(text, selected);
            this.description = text;
            this.setToolTipText(MessageSuppressionPanel.TOOLTIP_TEXT);
        }

        public int compareTo(Object o) {
            return this.description.compareTo(((MessageSuppressionCheckBox)o).description);
        }
    }

    private class MessageSuppressionItemListener
    implements ItemListener {
        private MessageSuppressionItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            String selectedMessageKey = (String)MessageSuppressionPanel.this.checkBoxMessageKeyTable.get(e.getItemSelectable());
            if (e.getStateChange() == 2) {
                MessageManager.suppressMessage(selectedMessageKey);
            } else if (e.getStateChange() == 1) {
                MessageManager.unsuppressMessage(selectedMessageKey);
            }
        }
    }
}

